/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import org.apache.flink.shaded.guava30.com.google.common.base.MoreObjects;
import org.apache.flink.streaming.connectors.pulsar.internal.TopicRange;
import org.apache.pulsar.client.api.MessageId;

public class PulsarTopicState<T> {
    private final TopicRange topicRange;
    private volatile MessageId offset;
    private volatile MessageId committedOffset;

    public PulsarTopicState(String topic) {
        this.topicRange = new TopicRange(topic);
        this.offset = null;
        this.committedOffset = null;
    }

    public PulsarTopicState(String topic, int start, int end) {
        this.topicRange = new TopicRange(topic, start, end);
    }

    public PulsarTopicState(TopicRange topicRange) {
        this.topicRange = topicRange;
    }

    public final boolean isOffsetDefined() {
        return this.offset != null;
    }

    public final void setCommittedOffset(MessageId offset) {
        this.committedOffset = offset;
    }

    public final MessageId getCommittedOffset() {
        return this.committedOffset;
    }

    public long extractTimestamp(T record, long pulsarEventTimestamp) {
        return pulsarEventTimestamp;
    }

    public void onEvent(T event, long timestamp) {
    }

    public void onPeriodicEmit() {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topicRange", (Object)this.getTopicRange()).add("offset", (Object)(this.isOffsetDefined() ? this.getOffset().toString() : "not set")).toString();
    }

    public TopicRange getTopicRange() {
        return this.topicRange;
    }

    public MessageId getOffset() {
        return this.offset;
    }

    public void setOffset(MessageId offset) {
        this.offset = offset;
    }
}

