/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.flink.streaming.connectors.pulsar.internal.DateTimeUtils;
import org.apache.flink.streaming.connectors.pulsar.internal.JSONOptions;
import org.apache.flink.streaming.connectors.pulsar.internal.ParseMode;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.flink.util.ExceptionUtils;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonEncoding;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonFactory;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonParser;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonRecordParser {
    private static final Logger log = LoggerFactory.getLogger(JacksonRecordParser.class);
    private final DataType schema;
    private final JSONOptions options;
    private final JsonFactory factory;
    private final BiFunction<JsonParser, Row, Row> rootConverter;

    public JacksonRecordParser(DataType schema, JSONOptions options) {
        assert (schema instanceof FieldsDataType);
        this.schema = schema;
        this.options = options;
        this.rootConverter = this.makeStructRootConverter((FieldsDataType)schema);
        this.factory = new JsonFactory();
        options.setJacksonOptions(this.factory);
    }

    private BiFunction<JsonParser, Row, Row> makeStructRootConverter(FieldsDataType st) {
        List fieldNames = ((RowType)st.getLogicalType()).getFieldNames();
        ArrayList<Function<JsonParser, Object>> fieldConverters = new ArrayList<Function<JsonParser, Object>>();
        RowType rowType = (RowType)st.getLogicalType();
        for (int i = 0; i < fieldNames.size(); ++i) {
            LogicalType logicalType = rowType.getTypeAt(i);
            DataType type = TypeConversions.fromLogicalToDataType((LogicalType)logicalType);
            fieldConverters.add(this.makeConverter(type));
        }
        return (parser, row) -> {
            try {
                this.parseJsonToken((JsonParser)parser, (DataType)st, new PartialFunc((JsonParser)parser, st, fieldConverters, (Row)row){
                    final /* synthetic */ JsonParser val$parser;
                    final /* synthetic */ FieldsDataType val$st;
                    final /* synthetic */ List val$fieldConverters;
                    final /* synthetic */ Row val$row;
                    {
                        this.val$parser = jsonParser;
                        this.val$st = fieldsDataType;
                        this.val$fieldConverters = list;
                        this.val$row = row;
                    }

                    @Override
                    public boolean isDefinedAt(JsonToken token) {
                        return token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY;
                    }

                    @Override
                    public Object apply(JsonToken token) {
                        if (token == JsonToken.START_OBJECT) {
                            try {
                                return JacksonRecordParser.this.convertObject(this.val$parser, this.val$st, this.val$fieldConverters, this.val$row);
                            }
                            catch (IOException e) {
                                JacksonRecordParser.this.suroundWithRuntimeE(e);
                            }
                        } else {
                            throw new IllegalStateException("Message should be a single JSON object");
                        }
                        return null;
                    }
                });
            }
            catch (IOException e) {
                this.suroundWithRuntimeE(e);
            }
            return null;
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Row parse(String record, BiFunction<JsonFactory, String, JsonParser> createParser, Row row) throws BadRecordException {
        try (JsonParser parser = createParser.apply(this.factory, record);){
            JsonToken token = parser.nextToken();
            if (token == null) {
                Row row2 = new Row(0);
                return row2;
            }
            Row result = this.rootConverter.apply(parser, row);
            if (result == null) {
                throw new IllegalStateException("Root converter returned null");
            }
            Row row3 = result;
            return row3;
        }
        catch (Exception e) {
            throw new BadRecordException(record, e);
        }
    }

    private Row convertObject(JsonParser parser, FieldsDataType fdt, List<Function<JsonParser, Object>> fieldConverters, Row row) throws IOException {
        RowType rowType = (RowType)fdt.getLogicalType();
        List fieldNames = rowType.getFieldNames();
        while (this.nextUntil(parser, JsonToken.END_OBJECT)) {
            int index = fieldNames.indexOf(parser.getCurrentName());
            if (index == -1) {
                parser.skipChildren();
                continue;
            }
            row.setField(index, fieldConverters.get(index).apply(parser));
        }
        return row;
    }

    private void suroundWithRuntimeE(Exception e) {
        log.error("Failed to parse json due to {}", (Object)ExceptionUtils.stringifyException((Throwable)e));
        throw new IllegalStateException(e);
    }

    private boolean nextUntil(JsonParser parser, JsonToken stopOn) throws IOException {
        JsonToken token = parser.nextToken();
        if (token == null) {
            return false;
        }
        return token != stopOn;
    }

    private Function<JsonParser, Object> makeConverter(DataType dataType) {
        LogicalTypeRoot tpe = dataType.getLogicalType().getTypeRoot();
        switch (tpe) {
            case BOOLEAN: {
                return parser -> {
                    try {
                        return this.parseJsonToken((JsonParser)parser, dataType, new PartialFunc(){

                            @Override
                            public boolean isDefinedAt(JsonToken token) {
                                return token == JsonToken.VALUE_TRUE || token == JsonToken.VALUE_FALSE;
                            }

                            @Override
                            public Object apply(JsonToken token) {
                                return token == JsonToken.VALUE_TRUE;
                            }
                        });
                    }
                    catch (IOException e) {
                        this.suroundWithRuntimeE(e);
                        return null;
                    }
                };
            }
            case TINYINT: {
                return parser -> {
                    try {
                        return this.parseJsonToken((JsonParser)parser, dataType, new PartialFunc((JsonParser)parser){
                            final /* synthetic */ JsonParser val$parser;
                            {
                                this.val$parser = jsonParser;
                            }

                            @Override
                            public boolean isDefinedAt(JsonToken token) {
                                return token == JsonToken.VALUE_NUMBER_INT;
                            }

                            @Override
                            public Object apply(JsonToken token) {
                                try {
                                    return this.val$parser.getByteValue();
                                }
                                catch (IOException e) {
                                    JacksonRecordParser.this.suroundWithRuntimeE(e);
                                    return null;
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        this.suroundWithRuntimeE(e);
                        return null;
                    }
                };
            }
            case SMALLINT: {
                return parser -> {
                    try {
                        return this.parseJsonToken((JsonParser)parser, dataType, new PartialFunc((JsonParser)parser){
                            final /* synthetic */ JsonParser val$parser;
                            {
                                this.val$parser = jsonParser;
                            }

                            @Override
                            public boolean isDefinedAt(JsonToken token) {
                                return token == JsonToken.VALUE_NUMBER_INT;
                            }

                            @Override
                            public Object apply(JsonToken token) {
                                try {
                                    return this.val$parser.getShortValue();
                                }
                                catch (IOException e) {
                                    JacksonRecordParser.this.suroundWithRuntimeE(e);
                                    return null;
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        this.suroundWithRuntimeE(e);
                        return null;
                    }
                };
            }
            case INTEGER: {
                return parser -> {
                    try {
                        return this.parseJsonToken((JsonParser)parser, dataType, new PartialFunc((JsonParser)parser){
                            final /* synthetic */ JsonParser val$parser;
                            {
                                this.val$parser = jsonParser;
                            }

                            @Override
                            public boolean isDefinedAt(JsonToken token) {
                                return token == JsonToken.VALUE_NUMBER_INT;
                            }

                            @Override
                            public Object apply(JsonToken token) {
                                try {
                                    return this.val$parser.getIntValue();
                                }
                                catch (IOException e) {
                                    JacksonRecordParser.this.suroundWithRuntimeE(e);
                                    return null;
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        this.suroundWithRuntimeE(e);
                        return null;
                    }
                };
            }
            case BIGINT: {
                return parser -> {
                    try {
                        return this.parseJsonToken((JsonParser)parser, dataType, new PartialFunc((JsonParser)parser){
                            final /* synthetic */ JsonParser val$parser;
                            {
                                this.val$parser = jsonParser;
                            }

                            @Override
                            public boolean isDefinedAt(JsonToken token) {
                                return token == JsonToken.VALUE_NUMBER_INT;
                            }

                            @Override
                            public Object apply(JsonToken token) {
                                try {
                                    return this.val$parser.getLongValue();
                                }
                                catch (IOException e) {
                                    JacksonRecordParser.this.suroundWithRuntimeE(e);
                                    return null;
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        this.suroundWithRuntimeE(e);
                        return null;
                    }
                };
            }
            case FLOAT: {
                return parser -> {
                    try {
                        return this.parseJsonToken((JsonParser)parser, dataType, new PartialFunc((JsonParser)parser){
                            final /* synthetic */ JsonParser val$parser;
                            {
                                this.val$parser = jsonParser;
                            }

                            @Override
                            public boolean isDefinedAt(JsonToken token) {
                                return token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_NUMBER_FLOAT || token == JsonToken.VALUE_STRING;
                            }

                            @Override
                            public Object apply(JsonToken token) {
                                try {
                                    if (token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_NUMBER_FLOAT) {
                                        return Float.valueOf(this.val$parser.getFloatValue());
                                    }
                                    String txt = this.val$parser.getText();
                                    if (txt.equals("NaN")) {
                                        return Float.valueOf(Float.NaN);
                                    }
                                    if (txt.equals("Infinity")) {
                                        return Float.valueOf(Float.POSITIVE_INFINITY);
                                    }
                                    if (txt.equals("-Infinity")) {
                                        return Float.valueOf(Float.NEGATIVE_INFINITY);
                                    }
                                    throw new IllegalArgumentException("Cannot parse " + txt + " as Float");
                                }
                                catch (IOException e) {
                                    JacksonRecordParser.this.suroundWithRuntimeE(e);
                                    return null;
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        this.suroundWithRuntimeE(e);
                        return null;
                    }
                };
            }
            case DOUBLE: {
                return parser -> {
                    try {
                        return this.parseJsonToken((JsonParser)parser, dataType, new PartialFunc((JsonParser)parser){
                            final /* synthetic */ JsonParser val$parser;
                            {
                                this.val$parser = jsonParser;
                            }

                            @Override
                            public boolean isDefinedAt(JsonToken token) {
                                return token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_NUMBER_FLOAT || token == JsonToken.VALUE_STRING;
                            }

                            @Override
                            public Object apply(JsonToken token) {
                                try {
                                    if (token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_NUMBER_FLOAT) {
                                        return this.val$parser.getDoubleValue();
                                    }
                                    String txt = this.val$parser.getText();
                                    if (txt.equals("NaN")) {
                                        return Float.valueOf(Float.NaN);
                                    }
                                    if (txt.equals("Infinity")) {
                                        return Float.valueOf(Float.POSITIVE_INFINITY);
                                    }
                                    if (txt.equals("-Infinity")) {
                                        return Float.valueOf(Float.NEGATIVE_INFINITY);
                                    }
                                    throw new IllegalArgumentException("Cannot parse " + txt + " as Float");
                                }
                                catch (IOException e) {
                                    JacksonRecordParser.this.suroundWithRuntimeE(e);
                                    return null;
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        this.suroundWithRuntimeE(e);
                        return null;
                    }
                };
            }
            case VARCHAR: {
                return parser -> {
                    try {
                        return this.parseJsonToken((JsonParser)parser, dataType, new PartialFunc((JsonParser)parser){
                            final /* synthetic */ JsonParser val$parser;
                            {
                                this.val$parser = jsonParser;
                            }

                            @Override
                            public boolean isDefinedAt(JsonToken token) {
                                return true;
                            }

                            @Override
                            public Object apply(JsonToken token) {
                                try {
                                    if (token == JsonToken.VALUE_STRING) {
                                        return this.val$parser.getText();
                                    }
                                    ByteArrayOutputStream writer = new ByteArrayOutputStream();
                                    try (JsonGenerator generator = JacksonRecordParser.this.factory.createGenerator((OutputStream)writer, JsonEncoding.UTF8);){
                                        generator.copyCurrentStructure(this.val$parser);
                                    }
                                    return new String(writer.toByteArray(), StandardCharsets.UTF_8);
                                }
                                catch (IOException e) {
                                    JacksonRecordParser.this.suroundWithRuntimeE(e);
                                    return null;
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        this.suroundWithRuntimeE(e);
                        return null;
                    }
                };
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return parser -> {
                    try {
                        return this.parseJsonToken((JsonParser)parser, dataType, new PartialFunc((JsonParser)parser){
                            final /* synthetic */ JsonParser val$parser;
                            {
                                this.val$parser = jsonParser;
                            }

                            @Override
                            public boolean isDefinedAt(JsonToken token) {
                                return token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_STRING;
                            }

                            @Override
                            public Object apply(JsonToken token) {
                                try {
                                    if (token == JsonToken.VALUE_STRING) {
                                        String v = this.val$parser.getText();
                                        long t = JacksonRecordParser.this.options.getTimestampFormat().parse(v).getTime() * 1000L;
                                        return DateTimeUtils.toJavaTimestamp(t).toLocalDateTime();
                                    }
                                    return DateTimeUtils.toJavaTimestamp(this.val$parser.getLongValue() * 1000000L).toLocalDateTime();
                                }
                                catch (IOException | ParseException e) {
                                    JacksonRecordParser.this.suroundWithRuntimeE(e);
                                    return null;
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        this.suroundWithRuntimeE(e);
                        return null;
                    }
                };
            }
            case DATE: {
                return parser -> {
                    try {
                        return this.parseJsonToken((JsonParser)parser, dataType, new PartialFunc((JsonParser)parser){
                            final /* synthetic */ JsonParser val$parser;
                            {
                                this.val$parser = jsonParser;
                            }

                            @Override
                            public boolean isDefinedAt(JsonToken token) {
                                return token == JsonToken.VALUE_STRING;
                            }

                            @Override
                            public Object apply(JsonToken token) {
                                try {
                                    String v = this.val$parser.getText();
                                    int t = DateTimeUtils.millisToDays(JacksonRecordParser.this.options.getDateFormat().parse(v).getTime());
                                    return DateTimeUtils.toJavaDate(t).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                                }
                                catch (IOException | ParseException e) {
                                    JacksonRecordParser.this.suroundWithRuntimeE(e);
                                    return null;
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        this.suroundWithRuntimeE(e);
                        return null;
                    }
                };
            }
            case VARBINARY: {
                return parser -> {
                    try {
                        return this.parseJsonToken((JsonParser)parser, dataType, new PartialFunc((JsonParser)parser){
                            final /* synthetic */ JsonParser val$parser;
                            {
                                this.val$parser = jsonParser;
                            }

                            @Override
                            public boolean isDefinedAt(JsonToken token) {
                                return token == JsonToken.VALUE_STRING;
                            }

                            @Override
                            public Object apply(JsonToken token) {
                                try {
                                    return this.val$parser.getBinaryValue();
                                }
                                catch (IOException e) {
                                    JacksonRecordParser.this.suroundWithRuntimeE(e);
                                    return null;
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        this.suroundWithRuntimeE(e);
                        return null;
                    }
                };
            }
            case DECIMAL: {
                return parser -> {
                    try {
                        return this.parseJsonToken((JsonParser)parser, dataType, new PartialFunc((JsonParser)parser){
                            final /* synthetic */ JsonParser val$parser;
                            {
                                this.val$parser = jsonParser;
                            }

                            @Override
                            public boolean isDefinedAt(JsonToken token) {
                                return token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_NUMBER_FLOAT;
                            }

                            @Override
                            public Object apply(JsonToken token) {
                                try {
                                    return this.val$parser.getDecimalValue();
                                }
                                catch (IOException e) {
                                    JacksonRecordParser.this.suroundWithRuntimeE(e);
                                    return null;
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        this.suroundWithRuntimeE(e);
                        return null;
                    }
                };
            }
            case ROW: {
                final RowType rowType = (RowType)dataType.getLogicalType();
                List fieldNames = rowType.getFieldNames();
                ArrayList<Function<JsonParser, Object>> fieldConverters = new ArrayList<Function<JsonParser, Object>>();
                for (int i = 0; i < fieldNames.size(); ++i) {
                    LogicalType logicalType = rowType.getTypeAt(i);
                    fieldConverters.add(this.makeConverter(TypeConversions.fromLogicalToDataType((LogicalType)logicalType)));
                }
                return parser -> {
                    try {
                        return this.parseJsonToken((JsonParser)parser, dataType, new PartialFunc((JsonParser)parser, dataType, fieldConverters){
                            final /* synthetic */ JsonParser val$parser;
                            final /* synthetic */ DataType val$dataType;
                            final /* synthetic */ List val$fieldConverters;
                            {
                                this.val$parser = jsonParser;
                                this.val$dataType = dataType;
                                this.val$fieldConverters = list;
                            }

                            @Override
                            public boolean isDefinedAt(JsonToken token) {
                                return token == JsonToken.START_OBJECT;
                            }

                            @Override
                            public Object apply(JsonToken token) {
                                try {
                                    Row record = new Row(rowType.getFieldCount());
                                    return JacksonRecordParser.this.convertObject(this.val$parser, (FieldsDataType)this.val$dataType, this.val$fieldConverters, record);
                                }
                                catch (IOException e) {
                                    JacksonRecordParser.this.suroundWithRuntimeE(e);
                                    return null;
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        this.suroundWithRuntimeE(e);
                        return null;
                    }
                };
            }
        }
        throw new IllegalStateException(String.format("Failed to parse a value for data type %s (current: %s).", dataType.toString(), tpe.toString()));
    }

    public Object parseJsonToken(JsonParser parser, DataType dataType, PartialFunc f) throws IOException {
        while (true) {
            JsonToken currentToken;
            if (!JsonToken.FIELD_NAME.equals((Object)(currentToken = parser.getCurrentToken()))) {
                Object result = currentToken == null || JsonToken.VALUE_NULL.equals((Object)currentToken) ? null : f.applyOrElse(currentToken, parser, dataType);
                return result;
            }
            parser.nextToken();
        }
    }

    static class BadRecordException
    extends Exception {
        public String record;

        public BadRecordException(String record, Exception e) {
            super(e);
            this.record = record;
        }
    }

    static class FailureSafeRecordParser {
        private final BiFunctionWithException<String, Row, Row> rawParser;
        private final ParseMode mode;
        private final FieldsDataType schema;

        FailureSafeRecordParser(BiFunctionWithException<String, Row, Row> rawParser, ParseMode mode, FieldsDataType schema) {
            this.rawParser = rawParser;
            this.mode = mode;
            this.schema = schema;
        }

        Row parse(String input, Row row) {
            try {
                return this.rawParser.apply(input, row);
            }
            catch (BadRecordException e) {
                switch (this.mode) {
                    case PERMISSIVE: {
                        return row;
                    }
                    case DROPMALFORMED: {
                        return null;
                    }
                    case FAILFAST: {
                        throw new IllegalStateException("Malformed records are detected in record parsing", e);
                    }
                }
                return null;
            }
        }
    }

    static interface BiFunctionWithException<T, U, R> {
        public R apply(T var1, U var2) throws BadRecordException;
    }

    static interface PartialFunc {
        public boolean isDefinedAt(JsonToken var1);

        public Object apply(JsonToken var1);

        default public Object applyOrElse(JsonToken token, JsonParser parser, DataType dataType) throws IOException {
            if (this.isDefinedAt(token)) {
                return this.apply(token);
            }
            if (token == JsonToken.VALUE_STRING && parser.getTextLength() < 1) {
                return null;
            }
            throw new IllegalStateException(String.format("Failed to parse a value for data type %s (current token: %s).", dataType.toString(), token.toString()));
        }
    }
}

