/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.pulsar.internal.JSONOptions;

public class JSONOptionsInRead
extends JSONOptions {
    private static final List<Charset> blackList = Arrays.asList(StandardCharsets.UTF_16, Charset.forName("UTF-32"));
    private final transient Map<String, String> parameters;
    private final String defaultTimeZoneId;
    private final String defaultColumnNameOfCorruptRecord;

    public JSONOptionsInRead(Map<String, String> parameters, String defaultTimeZoneId, String defaultColumnNameOfCorruptRecord) {
        super(parameters, defaultTimeZoneId, defaultColumnNameOfCorruptRecord);
        this.parameters = parameters;
        this.defaultTimeZoneId = defaultTimeZoneId;
        this.defaultColumnNameOfCorruptRecord = defaultColumnNameOfCorruptRecord;
    }

    @Override
    protected String checkEncoding(String enc) {
        boolean isLineSepRequired;
        boolean isBlacklisted = blackList.contains(Charset.forName(enc));
        if (!this.multiLine && isBlacklisted) {
            throw new IllegalArgumentException(String.format("The %s encoding must not be included in the blacklist when multiLine is disabled", enc));
        }
        boolean bl = isLineSepRequired = this.multiLine || StandardCharsets.UTF_8.equals(Charset.forName(enc)) || this.lineSeparator != null;
        if (!isLineSepRequired) {
            throw new IllegalArgumentException(String.format("The lineSep must be specified for the %s encoding", enc));
        }
        return enc;
    }
}

