/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.flink.streaming.connectors.pulsar.internal.ParseMode;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonFactory;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonParser;
import org.apache.pulsar.shade.org.apache.commons.lang3.time.FastDateFormat;

public class JSONOptions
implements Serializable {
    private static final long serialVersionUID = -7011153183551222235L;
    private final boolean primitivesAsString;
    private final boolean prefersDecimal;
    private final boolean allowComments;
    private final boolean allowUnquotedFieldNames;
    private final boolean allowSingleQuotes;
    private final boolean allowNumericLeadingZeros;
    private final boolean allowNonNumericNumbers;
    private final boolean allowBackslashEscapingAnyCharacter;
    private final boolean allowUnquotedControlChars;
    private final ParseMode parseMode;
    private final String columnNameOfCorruptRecord;
    private final boolean dropFieldIfAllNull;
    private final ConcurrentHashMap<String, TimeZone> computedTimeZones;
    private final Function<String, TimeZone> computeTimeZone;
    private final TimeZone timeZone;
    private final FastDateFormat dateFormat;
    private final FastDateFormat timestampFormat;
    protected final boolean multiLine;
    protected final String lineSeparator;
    private final String encoding;
    private final byte[] lineSeparatorInRead;
    private final String lineSeparatorInWrite;
    private final transient Map<String, String> parameters;
    private final String defaultTimeZoneId;
    private final String defaultColumnNameOfCorruptRecord;

    public JSONOptions(Map<String, String> parameters, String defaultTimeZoneId, String defaultColumnNameOfCorruptRecord) {
        String enc;
        this.parameters = parameters;
        this.defaultTimeZoneId = defaultTimeZoneId;
        this.defaultColumnNameOfCorruptRecord = defaultColumnNameOfCorruptRecord;
        this.primitivesAsString = Boolean.valueOf(parameters.getOrDefault("primitivesAsString", "false"));
        this.prefersDecimal = Boolean.valueOf(parameters.getOrDefault("prefersDecimal", "false"));
        this.allowComments = Boolean.valueOf(parameters.getOrDefault("allowComments", "false"));
        this.allowUnquotedFieldNames = Boolean.valueOf(parameters.getOrDefault("allowUnquotedFieldNames", "false"));
        this.allowSingleQuotes = Boolean.valueOf(parameters.getOrDefault("allowSingleQuotes", "false"));
        this.allowNumericLeadingZeros = Boolean.valueOf(parameters.getOrDefault("allowNumericLeadingZeros", "false"));
        this.allowNonNumericNumbers = Boolean.valueOf(parameters.getOrDefault("allowNonNumericNumbers", "false"));
        this.allowBackslashEscapingAnyCharacter = Boolean.valueOf(parameters.getOrDefault("allowBackslashEscapingAnyCharacter", "false"));
        this.allowUnquotedControlChars = Boolean.valueOf(parameters.getOrDefault("allowUnquotedControlChars", "false"));
        this.columnNameOfCorruptRecord = parameters.getOrDefault("columnNameOfCorruptRecord", defaultColumnNameOfCorruptRecord);
        this.dropFieldIfAllNull = Boolean.valueOf(parameters.getOrDefault("dropFieldIfAllNull", "false"));
        this.parseMode = ParseMode.get(parameters.getOrDefault("mode", "PERMISSIVE"));
        this.multiLine = Boolean.valueOf(parameters.getOrDefault("multiLine", "false"));
        this.encoding = parameters.containsKey("encoding") || parameters.containsKey("charset") ? ((enc = (String)parameters.getOrDefault("encoding", parameters.getOrDefault("charset", null))) != null ? this.checkEncoding(enc) : null) : null;
        if (parameters.containsKey("lineSep")) {
            String lineSep = parameters.get("lineSep");
            Preconditions.checkArgument((!lineSep.isEmpty() ? 1 : 0) != 0);
            this.lineSeparator = lineSep;
            try {
                this.lineSeparatorInRead = this.encoding == null ? lineSep.getBytes("UTF-8") : lineSep.getBytes(this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            this.lineSeparatorInWrite = lineSep;
        } else {
            this.lineSeparator = null;
            this.lineSeparatorInRead = null;
            this.lineSeparatorInWrite = "\n";
        }
        this.computedTimeZones = new ConcurrentHashMap();
        this.computeTimeZone = timezoneId -> TimeZone.getTimeZone(timezoneId);
        this.timeZone = this.getTimeZone(parameters.getOrDefault("timezone", defaultTimeZoneId));
        this.dateFormat = FastDateFormat.getInstance((String)parameters.getOrDefault("dateFormat", "yyyy-MM-dd"), (Locale)Locale.US);
        this.timestampFormat = FastDateFormat.getInstance((String)parameters.getOrDefault("timestampFormat", "yyyy-MM-dd'T'HH:mm:ss.SSS"), (TimeZone)this.timeZone, (Locale)Locale.US);
    }

    protected String checkEncoding(String enc) {
        return enc;
    }

    private TimeZone getTimeZone(String timeZoneeId) {
        return this.computedTimeZones.computeIfAbsent(timeZoneeId, this.computeTimeZone);
    }

    public void setJacksonOptions(JsonFactory factory) {
        factory.configure(JsonParser.Feature.ALLOW_COMMENTS, this.allowComments);
        factory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, this.allowUnquotedFieldNames);
        factory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, this.allowSingleQuotes);
        factory.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, this.allowNumericLeadingZeros);
        factory.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, this.allowNonNumericNumbers);
        factory.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, this.allowBackslashEscapingAnyCharacter);
        factory.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, this.allowUnquotedControlChars);
    }

    public boolean isPrimitivesAsString() {
        return this.primitivesAsString;
    }

    public boolean isPrefersDecimal() {
        return this.prefersDecimal;
    }

    public boolean isAllowComments() {
        return this.allowComments;
    }

    public boolean isAllowUnquotedFieldNames() {
        return this.allowUnquotedFieldNames;
    }

    public boolean isAllowSingleQuotes() {
        return this.allowSingleQuotes;
    }

    public boolean isAllowNumericLeadingZeros() {
        return this.allowNumericLeadingZeros;
    }

    public boolean isAllowNonNumericNumbers() {
        return this.allowNonNumericNumbers;
    }

    public boolean isAllowBackslashEscapingAnyCharacter() {
        return this.allowBackslashEscapingAnyCharacter;
    }

    public boolean isAllowUnquotedControlChars() {
        return this.allowUnquotedControlChars;
    }

    public ParseMode getParseMode() {
        return this.parseMode;
    }

    public String getColumnNameOfCorruptRecord() {
        return this.columnNameOfCorruptRecord;
    }

    public boolean isDropFieldIfAllNull() {
        return this.dropFieldIfAllNull;
    }

    public ConcurrentHashMap<String, TimeZone> getComputedTimeZones() {
        return this.computedTimeZones;
    }

    public Function<String, TimeZone> getComputeTimeZone() {
        return this.computeTimeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public FastDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public FastDateFormat getTimestampFormat() {
        return this.timestampFormat;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getLineSeparatorInRead() {
        return this.lineSeparatorInRead;
    }

    public String getLineSeparatorInWrite() {
        return this.lineSeparatorInWrite;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getDefaultTimeZoneId() {
        return this.defaultTimeZoneId;
    }

    public String getDefaultColumnNameOfCorruptRecord() {
        return this.defaultColumnNameOfCorruptRecord;
    }
}

