/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.formats.protobufnative;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.io.IOException;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.connectors.pulsar.formats.protobufnative.PulsarProtobufToRowDataConverters;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.function.SerializableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarProtobufNativeRowDataDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final Logger log = LoggerFactory.getLogger(PulsarProtobufNativeRowDataDeserializationSchema.class);
    private SerializableSupplier<Descriptors.Descriptor> loadDescriptor;
    private RowType rowType;
    private TypeInformation<RowData> rowDataTypeInfo;
    private transient Descriptors.Descriptor descriptor;
    private transient PulsarProtobufToRowDataConverters.ProtobufToRowDataConverter runtimeConverter;

    public PulsarProtobufNativeRowDataDeserializationSchema(SerializableSupplier<Descriptors.Descriptor> loadDescriptor, RowType rowType) {
        this.loadDescriptor = loadDescriptor;
        this.rowType = rowType;
        this.rowDataTypeInfo = InternalTypeInfo.of((RowType)rowType);
    }

    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.descriptor = (Descriptors.Descriptor)this.loadDescriptor.get();
        this.runtimeConverter = PulsarProtobufToRowDataConverters.createRowConverter(this.rowType);
    }

    public RowData deserialize(byte[] message) throws IOException {
        if (message == null) {
            return null;
        }
        try {
            DynamicMessage deserialize = DynamicMessage.parseFrom((Descriptors.Descriptor)this.descriptor, (byte[])message);
            return (RowData)this.runtimeConverter.convert(deserialize);
        }
        catch (Exception e) {
            throw new IOException("Failed to deserialize ProtobufNative record.", e);
        }
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.rowDataTypeInfo;
    }
}

