/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.formats.atomic;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.streaming.connectors.pulsar.internal.IncompatibleSchemaException;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarDeserializer;
import org.apache.flink.streaming.connectors.pulsar.internal.SimpleSchemaTranslator;
import org.apache.flink.streaming.connectors.pulsar.util.RowDataUtil;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.pulsar.client.api.Schema;

public class AtomicRowDataSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = -2885556750743978636L;
    private final DataType atomicType;
    private final String className;
    private final boolean useExtendFields;
    private final Class<?> clazz;
    private final PulsarDeserializer.Function<Object, byte[]> converter;

    private AtomicRowDataSerializationSchema(String className, boolean useExtendFields) {
        this.className = className;
        this.useExtendFields = useExtendFields;
        try {
            this.clazz = Class.forName(className);
            this.converter = this.getRuntimeConverter(this.clazz);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.atomicType = (DataType)TypeConversions.fromClassToDataType(this.clazz).orElseThrow(() -> new IllegalStateException(this.clazz.getCanonicalName() + " cant cast to flink dataType"));
    }

    public byte[] serialize(RowData row) {
        try {
            Object value = RowDataUtil.getField(row, 0, this.clazz);
            byte[] valueData = this.converter.apply(value);
            return valueData;
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException("Could not serialize row '" + row + "'. Make sure that the schema matches the input.", t);
        }
    }

    private PulsarDeserializer.Function<Object, byte[]> getRuntimeConverter(Class<?> clazz) {
        return o -> {
            try {
                Schema schema = SimpleSchemaTranslator.sqlType2PulsarSchema(this.atomicType);
                return schema.encode(o);
            }
            catch (IncompatibleSchemaException e) {
                throw new IllegalStateException(e);
            }
        };
    }

    public DataType getAtomicType() {
        return this.atomicType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtomicRowDataSerializationSchema that = (AtomicRowDataSerializationSchema)o;
        if (this.useExtendFields != that.useExtendFields) {
            return false;
        }
        return this.className.equals(that.className);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = 31 * result + (this.useExtendFields ? 1 : 0);
        return result;
    }

    @PublicEvolving
    public static class Builder {
        private final String className;
        private boolean useExtendFields;

        public Builder(String className) {
            this.className = className;
        }

        public Builder useExtendFields(boolean useExtendFields) {
            this.useExtendFields = useExtendFields;
            return this;
        }

        public AtomicRowDataSerializationSchema build() {
            return new AtomicRowDataSerializationSchema(this.className, this.useExtendFields);
        }
    }
}

