/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.formats.atomic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.connectors.pulsar.internal.IncompatibleSchemaException;
import org.apache.flink.streaming.connectors.pulsar.internal.SimpleSchemaTranslator;
import org.apache.flink.streaming.connectors.pulsar.util.RowDataUtil;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.RowKind;
import org.apache.pulsar.client.api.Schema;

public class AtomicRowDataDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = -228294330688809195L;
    private final String className;
    private final boolean useExtendFields;
    private final Class<?> clazz;

    public AtomicRowDataDeserializationSchema(String className, boolean useExtendFields) {
        this.className = className;
        this.useExtendFields = useExtendFields;
        try {
            this.clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isUseExtendFields() {
        return this.useExtendFields;
    }

    public RowData deserialize(byte[] message) throws IOException {
        DataType dataType = (DataType)TypeConversions.fromClassToDataType(this.clazz).orElseThrow(() -> new IllegalStateException(this.clazz.getCanonicalName() + "cant cast to flink dataType"));
        try {
            Schema schema = SimpleSchemaTranslator.sqlType2PulsarSchema(dataType);
            Object data = schema.decode(message);
            GenericRowData rowData = new GenericRowData(RowKind.INSERT, 1);
            RowDataUtil.setField(rowData, 0, data);
            return rowData;
        }
        catch (IncompatibleSchemaException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        FieldsDataType fieldsDataType;
        ArrayList<DataTypes.Field> mainSchema = new ArrayList<DataTypes.Field>();
        DataType dataType = (DataType)TypeConversions.fromClassToDataType(this.clazz).orElseThrow(() -> new IllegalStateException(this.clazz.getCanonicalName() + "cant cast to flink dataType"));
        if (dataType instanceof FieldsDataType) {
            fieldsDataType = (FieldsDataType)dataType;
            RowType rowType = (RowType)fieldsDataType.getLogicalType();
            List fieldNames = rowType.getFieldNames();
            for (int i = 0; i < fieldNames.size(); ++i) {
                LogicalType logicalType = rowType.getTypeAt(i);
                DataTypes.Field field = DataTypes.FIELD((String)((String)fieldNames.get(i)), (DataType)TypeConversions.fromLogicalToDataType((LogicalType)logicalType));
                mainSchema.add(field);
            }
        } else {
            mainSchema.add(DataTypes.FIELD((String)"value", (DataType)dataType));
        }
        if (this.useExtendFields) {
            mainSchema.addAll(SimpleSchemaTranslator.METADATA_FIELDS);
        }
        fieldsDataType = (FieldsDataType)DataTypes.ROW((DataTypes.Field[])mainSchema.toArray(new DataTypes.Field[0]));
        return InternalTypeInfo.of((LogicalType)fieldsDataType.getLogicalType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtomicRowDataDeserializationSchema that = (AtomicRowDataDeserializationSchema)o;
        if (this.useExtendFields != that.useExtendFields) {
            return false;
        }
        return this.className.equals(that.className);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = 31 * result + (this.useExtendFields ? 1 : 0);
        return result;
    }

    public static class Builder {
        private final String className;
        private boolean useExtendFields;

        public Builder(String className) {
            this.className = className;
        }

        public Builder useExtendFields(boolean useExtendFields) {
            this.useExtendFields = useExtendFields;
            return this;
        }

        public AtomicRowDataDeserializationSchema build() {
            return new AtomicRowDataDeserializationSchema(this.className, this.useExtendFields);
        }
    }
}

