/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.catalog.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.flink.table.runtime.util.JsonUtils;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public final class TableSchemaHelper {
    private TableSchemaHelper() {
    }

    public static SchemaInfo generateSchemaInfo(Map<String, String> properties) throws JsonProcessingException {
        return SchemaInfoImpl.builder().name("flink_table_schema").type(SchemaType.BYTES).schema(JsonUtils.MAPPER.writeValueAsBytes(properties)).build();
    }

    public static Map<String, String> generateTableProperties(SchemaInfo schemaInfo) throws IOException {
        return (Map)JsonUtils.MAPPER.readValue(schemaInfo.getSchema(), (TypeReference)new TypeReference<HashMap<String, String>>(){});
    }
}

