/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.flink.api.java.tuple.Tuple2;

public class DateTimeUtils {
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final int to2001 = -11323;
    private static final int toYearZero = 7293527;
    private static final int daysIn400Years = 146097;
    private static final long MICROS_PER_MILLIS = 1000L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MICROS_PER_SECOND = 1000000L;
    private static ThreadLocal<DateFormat> threadLocalTimestampFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US));

    public static Date stringToTime(String s) {
        int indexOfGMT = s.indexOf("GMT");
        if (indexOfGMT != -1) {
            String s0 = s.substring(0, indexOfGMT);
            String s1 = s.substring(indexOfGMT + 3);
            return DateTimeUtils.stringToTime(s0 + s1);
        }
        if (!s.contains("T")) {
            if (s.contains(" ")) {
                return Timestamp.valueOf(s);
            }
            return java.sql.Date.valueOf(s);
        }
        LocalDateTime ldt = LocalDateTime.parse(s, DateTimeFormatter.ISO_DATE_TIME);
        return Date.from(ldt.toInstant(ZoneOffset.UTC));
    }

    public static int fromJavaDate(Date date) {
        return DateTimeUtils.millisToDays(date.getTime());
    }

    public static int millisToDays(long millisUtc) {
        return DateTimeUtils.millisToDays(millisUtc, DateTimeUtils.defaultTimeZone());
    }

    public static int millisToDays(long millisUtc, TimeZone timeZone) {
        long millisLocal = millisUtc + (long)timeZone.getOffset(millisUtc);
        return (int)Math.floor((double)millisLocal / 8.64E7);
    }

    public static TimeZone defaultTimeZone() {
        return TimeZone.getDefault();
    }

    public static long fromJavaTimestamp(Timestamp t) {
        if (t != null) {
            return t.getTime() * 1000L + (long)t.getNanos() / 1000L % 1000L;
        }
        return 0L;
    }

    public static String timestampToString(long us, TimeZone timeZone) {
        Timestamp ts = DateTimeUtils.toJavaTimestamp(us);
        String timestampString = ts.toString();
        DateFormat timestampFormat = DateTimeUtils.getThreadLocalTimestampFormat(timeZone);
        String formatted = timestampFormat.format(ts);
        if (timestampString.length() > 19 && !timestampString.substring(19).equals(".0")) {
            return formatted + timestampString.substring(19);
        }
        return formatted;
    }

    public static DateFormat getThreadLocalTimestampFormat(TimeZone timeZone) {
        DateFormat sdf = threadLocalTimestampFormat.get();
        sdf.setTimeZone(timeZone);
        return sdf;
    }

    public static Timestamp toJavaTimestamp(long us) {
        long seconds = us / 1000000L;
        long micros = us % 1000000L;
        if (micros < 0L) {
            micros += 1000000L;
            --seconds;
        }
        Timestamp t = new Timestamp(seconds * 1000L);
        t.setNanos((int)micros * 1000);
        return t;
    }

    public static Date toJavaDate(int daysSinceEpoch) {
        return new Date(DateTimeUtils.daysToMillis(daysSinceEpoch));
    }

    public static long daysToMillis(int days) {
        return DateTimeUtils.daysToMillis(days, DateTimeUtils.defaultTimeZone());
    }

    public static long daysToMillis(int days, TimeZone timeZone) {
        long millisLocal = (long)days * 86400000L;
        return millisLocal - DateTimeUtils.getOffsetFromLocalMillis(millisLocal, timeZone);
    }

    private static long getOffsetFromLocalMillis(long millisLocal, TimeZone tz) {
        int guess = tz.getRawOffset();
        int offset = tz.getOffset(millisLocal - (long)guess);
        if (offset != guess && (guess = tz.getOffset(millisLocal - (long)offset)) != offset) {
            int days = (int)Math.floor((double)millisLocal / 8.64E7);
            int year = DateTimeUtils.getYear(days);
            int month = DateTimeUtils.getMonth(days);
            int day = DateTimeUtils.getDayOfMonth(days);
            int millisOfDay = (int)(millisLocal % 86400000L);
            if (millisOfDay < 0) {
                millisOfDay += 86400000;
            }
            int seconds = (int)((long)millisOfDay / 1000L);
            int hh = seconds / 3600;
            int mm = seconds / 60 % 60;
            int ss = seconds % 60;
            int ms = millisOfDay % 1000;
            Calendar calendar = Calendar.getInstance(tz);
            calendar.set(year, month - 1, day, hh, mm, ss);
            calendar.set(14, ms);
            guess = (int)(millisLocal - calendar.getTimeInMillis());
        }
        return guess;
    }

    public static int getYear(int date) {
        return (Integer)DateTimeUtils.getYearAndDayInYear((int)date).f0;
    }

    private static Tuple2<Integer, Integer> getYearAndDayInYear(int daysSince1970) {
        int daysSince1970Tmp = daysSince1970;
        if (daysSince1970 <= -141428) {
            daysSince1970Tmp -= 10;
        }
        int daysNormalized = daysSince1970Tmp + 7293527;
        int numOfQuarterCenturies = daysNormalized / 146097;
        int daysInThis400 = daysNormalized % 146097 + 1;
        Tuple2<Integer, Integer> yD = DateTimeUtils.numYears(daysInThis400);
        int year = -17999 + 400 * numOfQuarterCenturies + (Integer)yD.f0;
        return Tuple2.of((Object)year, (Object)yD.f1);
    }

    private static Tuple2<Integer, Integer> numYears(int days) {
        int year = days / 365;
        int boundary = DateTimeUtils.yearBoundary(year);
        if (days > boundary) {
            return new Tuple2((Object)year, (Object)(days - boundary));
        }
        return new Tuple2((Object)(year - 1), (Object)(days - DateTimeUtils.yearBoundary(year - 1)));
    }

    private static int yearBoundary(int year) {
        return year * 365 + (year / 4 - year / 100 + year / 400);
    }

    public static int getMonth(int date) {
        Tuple2<Integer, Integer> entry = DateTimeUtils.getYearAndDayInYear(date);
        int year = (Integer)entry.f0;
        int dayInYear = (Integer)entry.f1;
        if (DateTimeUtils.isLeapYear(year)) {
            if (dayInYear == 60) {
                return 2;
            }
            if (dayInYear > 60) {
                --dayInYear;
            }
        }
        if (dayInYear <= 31) {
            return 1;
        }
        if (dayInYear <= 59) {
            return 2;
        }
        if (dayInYear <= 90) {
            return 3;
        }
        if (dayInYear <= 120) {
            return 4;
        }
        if (dayInYear <= 151) {
            return 5;
        }
        if (dayInYear <= 181) {
            return 6;
        }
        if (dayInYear <= 212) {
            return 7;
        }
        if (dayInYear <= 243) {
            return 8;
        }
        if (dayInYear <= 273) {
            return 9;
        }
        if (dayInYear <= 304) {
            return 10;
        }
        if (dayInYear <= 334) {
            return 11;
        }
        return 12;
    }

    public static int getDayOfMonth(int date) {
        Tuple2<Integer, Integer> entry = DateTimeUtils.getYearAndDayInYear(date);
        int year = (Integer)entry.f0;
        int dayInYear = (Integer)entry.f1;
        if (DateTimeUtils.isLeapYear(year)) {
            if (dayInYear == 60) {
                return 29;
            }
            if (dayInYear > 60) {
                --dayInYear;
            }
        }
        if (dayInYear <= 31) {
            return dayInYear;
        }
        if (dayInYear <= 59) {
            return dayInYear - 31;
        }
        if (dayInYear <= 90) {
            return dayInYear - 59;
        }
        if (dayInYear <= 120) {
            return dayInYear - 90;
        }
        if (dayInYear <= 151) {
            return dayInYear - 120;
        }
        if (dayInYear <= 181) {
            return dayInYear - 151;
        }
        if (dayInYear <= 212) {
            return dayInYear - 181;
        }
        if (dayInYear <= 243) {
            return dayInYear - 212;
        }
        if (dayInYear <= 273) {
            return dayInYear - 243;
        }
        if (dayInYear <= 304) {
            return dayInYear - 273;
        }
        if (dayInYear <= 334) {
            return dayInYear - 304;
        }
        return dayInYear - 334;
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }
}

