/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiPredicate;
import org.apache.flink.util.function.BiConsumerWithException;
import org.apache.flink.util.function.FunctionWithException;

public class AsyncUtils {
    public static <T, R, C extends CompletableFuture<R>, E extends Exception> void parallelAsync(List<T> elements, FunctionWithException<T, C, E> asyncInvoker, BiConsumerWithException<T, R, E> consumer, Class<E> exceptionClass) throws E, InterruptedException, TimeoutException {
        AsyncUtils.parallelAsync(elements, asyncInvoker, (topic, exception) -> false, consumer, exceptionClass);
    }

    public static <T, R, C extends CompletableFuture<R>, E extends Exception> void parallelAsync(List<T> elements, FunctionWithException<T, C, E> asyncInvoker, BiPredicate<T, E> swallowException, BiConsumerWithException<T, R, E> consumer, Class<E> exceptionClass) throws E, InterruptedException, TimeoutException {
        ArrayList<Object> asyncFutures = new ArrayList<Object>();
        for (T element : elements) {
            asyncFutures.add(asyncInvoker.apply(element));
        }
        for (int index = 0; index < asyncFutures.size(); ++index) {
            try {
                Object result = ((CompletableFuture)asyncFutures.get(index)).get(60L, TimeUnit.SECONDS);
                consumer.accept(elements.get(index), result);
                continue;
            }
            catch (ExecutionException e) {
                Exception cause = (Exception)exceptionClass.cast(e.getCause());
                if (swallowException.test(elements.get(index), cause)) continue;
                throw cause;
            }
            catch (TimeoutException e) {
                throw new TimeoutException("Timeout while waiting for " + elements.get(index));
            }
        }
    }
}

