/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.pulsar;

import org.apache.flink.streaming.connectors.pulsar.table.PulsarTableOptions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.CatalogDescriptorValidator;
import org.apache.flink.table.descriptors.DescriptorProperties;

public class PulsarCatalogValidator
extends CatalogDescriptorValidator {
    public static final String CATALOG_TYPE_VALUE_PULSAR = "pulsar";
    public static final String CATALOG_PULSAR_VERSION = "pulsar-version";
    public static final String CATALOG_SERVICE_URL = PulsarTableOptions.SERVICE_URL.key();
    public static final String CATALOG_ADMIN_URL = PulsarTableOptions.ADMIN_URL.key();
    public static final String CATALOG_STARTUP_MODE = PulsarTableOptions.SCAN_STARTUP_MODE.key();
    public static final String CATALOG_DEFAULT_PARTITIONS = "table-default-partitions";

    public void validate(DescriptorProperties properties) {
        super.validate(properties);
        properties.validateValue("type", CATALOG_TYPE_VALUE_PULSAR, false);
        properties.validateString(CATALOG_PULSAR_VERSION, true, 1);
        properties.validateString(CATALOG_SERVICE_URL, false, 1);
        properties.validateString(CATALOG_ADMIN_URL, false, 1);
        properties.validateInt(CATALOG_DEFAULT_PARTITIONS, true, 1);
        properties.validateString("format", false);
        this.validateStartingOffsets(properties);
    }

    private void validateStartingOffsets(DescriptorProperties properties) {
        String v;
        if (properties.containsKey(CATALOG_STARTUP_MODE) && !(v = properties.getString(CATALOG_STARTUP_MODE)).equals("earliest") && !v.equals("latest")) {
            throw new ValidationException(CATALOG_STARTUP_MODE + " should be either earliest or latest");
        }
    }
}

