/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.pulsar;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.connectors.pulsar.internal.IncompatibleSchemaException;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarCatalogSupport;
import org.apache.flink.streaming.connectors.pulsar.internal.SimpleSchemaTranslator;
import org.apache.flink.streaming.connectors.pulsar.table.PulsarDynamicTableFactory;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.Factory;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarCatalog
extends GenericInMemoryCatalog {
    private static final Logger log = LoggerFactory.getLogger(PulsarCatalog.class);
    private String adminUrl;
    private Configuration configuration;
    private PulsarCatalogSupport catalogSupport;

    public PulsarCatalog(String adminUrl, String catalogName, Configuration configuration, String defaultDatabase) {
        super(catalogName, defaultDatabase);
        this.adminUrl = adminUrl;
        this.configuration = configuration;
        log.info("Created Pulsar Catalog {}", (Object)catalogName);
    }

    public Optional<Factory> getFactory() {
        return Optional.of(new PulsarDynamicTableFactory(true));
    }

    public void open() throws CatalogException {
        if (this.catalogSupport == null) {
            try {
                ClientConfigurationData clientConf = new ClientConfigurationData();
                clientConf.setAuthParams(this.configuration.getString("properties.auth-params", null));
                clientConf.setAuthPluginClassName(this.configuration.getString("properties.auth-plugin-classname", null));
                this.catalogSupport = new PulsarCatalogSupport(this.adminUrl, clientConf, "", new HashMap<String, String>(), -1, -1, new SimpleSchemaTranslator(false));
            }
            catch (PulsarClientException e) {
                throw new CatalogException("Failed to create Pulsar admin using " + this.adminUrl, (Throwable)e);
            }
        }
    }

    public void close() throws CatalogException {
        if (this.catalogSupport != null) {
            this.catalogSupport.close();
            this.catalogSupport = null;
            log.info("Close connection to Pulsar");
        }
    }

    public List<String> listDatabases() throws CatalogException {
        try {
            return this.catalogSupport.listNamespaces();
        }
        catch (PulsarAdminException e) {
            throw new CatalogException(String.format("Failed to list all databases in %s", this.getName()), (Throwable)e);
        }
    }

    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        HashMap properties = new HashMap();
        return new CatalogDatabaseImpl(properties, databaseName);
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        try {
            return this.catalogSupport.namespaceExists(databaseName);
        }
        catch (PulsarAdminException e) {
            return false;
        }
        catch (Exception e) {
            log.warn("{} database does not exist. {}", (Object)databaseName, (Object)e.getMessage());
            return false;
        }
    }

    public void createDatabase(String name, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        try {
            this.catalogSupport.createNamespace(name);
        }
        catch (PulsarAdminException.ConflictException e) {
            if (!ignoreIfExists) {
                throw new DatabaseAlreadyExistException(this.getName(), name, (Throwable)e);
            }
        }
        catch (PulsarAdminException e) {
            throw new CatalogException(String.format("Failed to create database %s", name), (Throwable)e);
        }
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        try {
            return this.catalogSupport.getTopics(databaseName);
        }
        catch (PulsarAdminException.NotFoundException e) {
            throw new DatabaseNotExistException(this.getName(), databaseName, (Throwable)e);
        }
        catch (PulsarAdminException e) {
            throw new CatalogException(String.format("Failed to list tables in database %s", databaseName), (Throwable)e);
        }
    }

    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        if (tablePath.getObjectName().startsWith("_tmp_table_")) {
            return super.getTable(tablePath);
        }
        try {
            return this.catalogSupport.getTableSchema(tablePath, this.configuration);
        }
        catch (PulsarAdminException.NotFoundException e) {
            throw new TableNotExistException(this.getName(), tablePath, (Throwable)e);
        }
        catch (IncompatibleSchemaException | PulsarAdminException e) {
            throw new CatalogException(String.format("Failed to get table %s schema", tablePath.getFullName()), e);
        }
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        if (tablePath.getObjectName().startsWith("_tmp_table_")) {
            return super.tableExists(tablePath);
        }
        try {
            return this.catalogSupport.topicExists(tablePath);
        }
        catch (PulsarAdminException.NotFoundException e) {
            return false;
        }
        catch (PulsarAdminException e) {
            throw new CatalogException(String.format("Failed to check table %s existence", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        Boolean databaseExists;
        if (tablePath.getObjectName().startsWith("_tmp_table_")) {
            super.createTable(tablePath, table, ignoreIfExists);
        }
        int defaultNumPartitions = this.configuration.getInteger("table-default-partitions", 5);
        String databaseName = tablePath.getDatabaseName();
        try {
            databaseExists = this.catalogSupport.namespaceExists(databaseName);
        }
        catch (PulsarAdminException e) {
            throw new CatalogException(String.format("Failed to check existence of databases %s", databaseName), (Throwable)e);
        }
        if (!databaseExists.booleanValue()) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        try {
            this.catalogSupport.createTopic(tablePath, defaultNumPartitions, table);
            this.catalogSupport.putSchema(tablePath, table, this.configuration);
        }
        catch (PulsarAdminException e) {
            if (e.getStatusCode() == 409) {
                throw new TableAlreadyExistException(this.getName(), tablePath, (Throwable)e);
            }
            throw new CatalogException(String.format("Failed to create table %s", tablePath.getFullName()), (Throwable)e);
        }
        catch (IncompatibleSchemaException e) {
            throw new CatalogException("Failed to translate Flink type to Pulsar", (Throwable)e);
        }
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterDatabase(String name, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<String> listViews(String databaseName) throws DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        try {
            this.catalogSupport.deleteTopic(tablePath);
        }
        catch (PulsarAdminException.NotFoundException e) {
            if (!ignoreIfNotExists) {
                throw new TableNotExistException(this.getName(), tablePath, (Throwable)e);
            }
        }
        catch (RuntimeException | PulsarAdminException e) {
            throw new CatalogException(String.format("Failed to drop table %s", tablePath.getFullName()), e);
        }
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> expressions) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }
}

