/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.util;

import java.io.Serializable;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;

public class MessageIdUtils {
    private static final MessageIdOperate<MessageIdImpl> messageIdImplOperate = new MessageIdImplOperate();
    private static final MessageIdOperate<BatchMessageIdImpl> batchMessageIdImplOperate = new BatchMessageIdImplOperate();

    public static MessageId next(MessageId current) {
        return MessageIdUtils.getOperate(current).next(current);
    }

    public static MessageId prev(MessageId current) {
        return MessageIdUtils.getOperate(current).prev(current);
    }

    private static <T extends MessageId> MessageIdOperate<T> getOperate(T current) {
        if (current instanceof BatchMessageIdImpl) {
            return batchMessageIdImplOperate;
        }
        if (current instanceof MessageIdImpl) {
            return messageIdImplOperate;
        }
        throw new UnsupportedOperationException("MessageId type: " + current.getClass().getCanonicalName());
    }

    public static class BatchMessageIdImplOperate
    implements MessageIdOperate<BatchMessageIdImpl> {
        @Override
        public MessageId next(BatchMessageIdImpl current) {
            return new MessageIdImpl(current.getLedgerId(), current.getEntryId() + 1L, current.getPartitionIndex());
        }

        @Override
        public MessageId prev(BatchMessageIdImpl current) {
            return current.prevBatchMessageId();
        }
    }

    public static class MessageIdImplOperate
    implements MessageIdOperate<MessageIdImpl> {
        @Override
        public MessageId next(MessageIdImpl current) {
            return new MessageIdImpl(current.getLedgerId(), current.getEntryId() + 1L, current.getPartitionIndex());
        }

        @Override
        public MessageId prev(MessageIdImpl current) {
            return new MessageIdImpl(current.getLedgerId(), current.getEntryId() - 1L, current.getPartitionIndex());
        }
    }

    public static interface MessageIdOperate<T extends MessageId>
    extends Serializable {
        public MessageId next(T var1);

        public MessageId prev(T var1);
    }
}

