/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.io.Serializable;
import org.apache.flink.streaming.connectors.pulsar.internal.SerializableRange;

public class TopicSubscription
implements Serializable {
    private String topic;
    private SerializableRange range;
    private String subscriptionName;

    private static SerializableRange $default$range() {
        return SerializableRange.ofFullRange();
    }

    public static TopicSubscriptionBuilder builder() {
        return new TopicSubscriptionBuilder();
    }

    public String getTopic() {
        return this.topic;
    }

    public SerializableRange getRange() {
        return this.range;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setRange(SerializableRange range) {
        this.range = range;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicSubscription)) {
            return false;
        }
        TopicSubscription other = (TopicSubscription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        SerializableRange this$range = this.getRange();
        SerializableRange other$range = other.getRange();
        if (this$range == null ? other$range != null : !((Object)this$range).equals(other$range)) {
            return false;
        }
        String this$subscriptionName = this.getSubscriptionName();
        String other$subscriptionName = other.getSubscriptionName();
        return !(this$subscriptionName == null ? other$subscriptionName != null : !this$subscriptionName.equals(other$subscriptionName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TopicSubscription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        SerializableRange $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : ((Object)$range).hashCode());
        String $subscriptionName = this.getSubscriptionName();
        result = result * 59 + ($subscriptionName == null ? 43 : $subscriptionName.hashCode());
        return result;
    }

    public String toString() {
        return "TopicSubscription(topic=" + this.getTopic() + ", range=" + this.getRange() + ", subscriptionName=" + this.getSubscriptionName() + ")";
    }

    public TopicSubscription() {
        this.range = TopicSubscription.$default$range();
    }

    public TopicSubscription(String topic, SerializableRange range, String subscriptionName) {
        this.topic = topic;
        this.range = range;
        this.subscriptionName = subscriptionName;
    }

    public static class TopicSubscriptionBuilder {
        private String topic;
        private boolean range$set;
        private SerializableRange range$value;
        private String subscriptionName;

        TopicSubscriptionBuilder() {
        }

        public TopicSubscriptionBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public TopicSubscriptionBuilder range(SerializableRange range) {
            this.range$value = range;
            this.range$set = true;
            return this;
        }

        public TopicSubscriptionBuilder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public TopicSubscription build() {
            SerializableRange range$value = this.range$value;
            if (!this.range$set) {
                range$value = TopicSubscription.$default$range();
            }
            return new TopicSubscription(this.topic, range$value, this.subscriptionName);
        }

        public String toString() {
            return "TopicSubscription.TopicSubscriptionBuilder(topic=" + this.topic + ", range$value=" + this.range$value + ", subscriptionName=" + this.subscriptionName + ")";
        }
    }
}

