/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import com.google.protobuf.GeneratedMessageV3;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.formats.protobuf.PbFormatOptions;
import org.apache.flink.streaming.connectors.pulsar.config.RecordSchemaType;
import org.apache.flink.streaming.connectors.pulsar.internal.IncompatibleSchemaException;
import org.apache.flink.streaming.connectors.pulsar.internal.SimpleSchemaTranslator;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.client.internal.DefaultImplementation;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.protocol.schema.PostSchemaPayload;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtils {
    private static final Logger log = LoggerFactory.getLogger(SchemaUtils.class);
    private static final org.apache.pulsar.shade.org.apache.avro.Schema NULL_SCHEMA = org.apache.pulsar.shade.org.apache.avro.Schema.create((Schema.Type)Schema.Type.NULL);
    private static int[] minBytesForPrecision = new int[39];

    public static void uploadPulsarSchema(PulsarAdmin admin, String topic, SchemaInfo schemaInfo) {
        SchemaInfo existingSchema;
        Preconditions.checkNotNull((Object)schemaInfo);
        try {
            existingSchema = admin.schemas().getSchemaInfo(TopicName.get((String)topic).toString());
        }
        catch (PulsarAdminException pae) {
            if (pae.getStatusCode() == 404) {
                existingSchema = null;
            }
            throw new RuntimeException(String.format("Failed to get schema information for %s", TopicName.get((String)topic).toString()), pae);
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("Failed to get schema information for %s", TopicName.get((String)topic).toString()), e);
        }
        if (existingSchema == null) {
            PostSchemaPayload pl = new PostSchemaPayload();
            pl.setType(schemaInfo.getType().name());
            pl.setSchema(SchemaUtils.getSchemaString(schemaInfo));
            pl.setProperties(schemaInfo.getProperties());
            try {
                admin.schemas().createSchema(TopicName.get((String)topic).toString(), pl);
            }
            catch (PulsarAdminException pae) {
                if (pae.getStatusCode() == 404) {
                    throw new RuntimeException(String.format("Create schema for %s get 404", TopicName.get((String)topic).toString()), pae);
                }
                throw new RuntimeException(String.format("Failed to create schema information for %s", TopicName.get((String)topic).toString()), pae);
            }
            catch (Throwable e) {
                throw new RuntimeException(String.format("Failed to create schema information for %s", TopicName.get((String)topic).toString()), e);
            }
        } else if (!SchemaUtils.schemaEqualsIgnoreProperties(schemaInfo, existingSchema) && !SchemaUtils.compatibleSchema(existingSchema, schemaInfo)) {
            throw new RuntimeException("Writing to a topic which have incompatible schema");
        }
    }

    private static boolean schemaEqualsIgnoreProperties(SchemaInfo schemaInfo, SchemaInfo existingSchema) {
        return existingSchema.getType().equals((Object)schemaInfo.getType()) && Arrays.equals(existingSchema.getSchema(), schemaInfo.getSchema());
    }

    private static String getSchemaString(SchemaInfo schemaInfo) {
        byte[] schemaData = schemaInfo.getSchema();
        if (null == schemaData) {
            return null;
        }
        if (schemaInfo.getType() == SchemaType.KEY_VALUE) {
            return DefaultImplementation.convertKeyValueSchemaInfoDataToString((KeyValue)DefaultImplementation.decodeKeyValueSchemaInfo((SchemaInfo)schemaInfo));
        }
        return new String(schemaData, StandardCharsets.UTF_8);
    }

    public static boolean compatibleSchema(SchemaInfo s1, SchemaInfo s2) {
        if (s1.getType() == SchemaType.NONE && s2.getType() == SchemaType.BYTES) {
            return true;
        }
        return s1.getType() == SchemaType.BYTES && s2.getType() == SchemaType.NONE;
    }

    static GenericSchema<GenericRecord> avroSchema2PulsarSchema(org.apache.pulsar.shade.org.apache.avro.Schema avroSchema) {
        byte[] schemaBytes = avroSchema.toString().getBytes(StandardCharsets.UTF_8);
        SchemaInfoImpl si = new SchemaInfoImpl();
        si.setName("Avro");
        si.setSchema(schemaBytes);
        si.setType(SchemaType.AVRO);
        return org.apache.pulsar.client.api.Schema.generic((SchemaInfo)si);
    }

    public static SchemaInfoImpl emptySchemaInfo() {
        return SchemaInfoImpl.builder().name("empty").type(SchemaType.NONE).schema(new byte[0]).build();
    }

    private static int computeMinBytesForPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }

    public static SchemaInfo buildRowSchema(DataType dataType, RecordSchemaType recordSchemaType) {
        Schema avroSchema = AvroSchemaConverter.convertToSchema((LogicalType)dataType.getLogicalType());
        byte[] schemaBytes = avroSchema.toString().getBytes(StandardCharsets.UTF_8);
        SchemaInfoImpl si = new SchemaInfoImpl();
        si.setSchema(schemaBytes);
        switch (recordSchemaType) {
            case AVRO: {
                si.setName("Avro");
                si.setType(SchemaType.AVRO);
                break;
            }
            case JSON: {
                si.setName("Json");
                si.setType(SchemaType.JSON);
                break;
            }
            case ATOMIC: {
                try {
                    FieldsDataType fieldType = (FieldsDataType)dataType;
                    RowType rowType = (RowType)fieldType.getLogicalType();
                    DataType atomicType = TypeConversions.fromLogicalToDataType((LogicalType)rowType.getTypeAt(0));
                    return SimpleSchemaTranslator.atomicType2PulsarSchema(atomicType).getSchemaInfo();
                }
                catch (IncompatibleSchemaException e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new IllegalStateException("for now we just support json\u3001avro\u3001atomic format for rowData");
            }
        }
        return si;
    }

    public static <T> org.apache.pulsar.client.api.Schema<T> buildSchemaForRecordClazz(Class<T> recordClazz, RecordSchemaType recordSchemaType) {
        if (recordSchemaType == null) {
            return org.apache.pulsar.client.api.Schema.AVRO(recordClazz);
        }
        switch (recordSchemaType) {
            case AVRO: {
                return org.apache.pulsar.client.api.Schema.AVRO(recordClazz);
            }
            case JSON: {
                return org.apache.pulsar.client.api.Schema.JSON(recordClazz);
            }
            case PROTOBUF: {
                org.apache.pulsar.client.api.Schema tSchema = org.apache.pulsar.client.api.Schema.PROTOBUF_NATIVE(SchemaUtils.convertProtobuf(recordClazz));
                return tSchema;
            }
        }
        throw new IllegalArgumentException("not support schema type " + (Object)((Object)recordSchemaType));
    }

    private static <T extends GeneratedMessageV3> Class<T> convertProtobuf(Class recordClazz) {
        if (!GeneratedMessageV3.class.isAssignableFrom(recordClazz)) {
            throw new IllegalArgumentException("Message classes must extend GeneratedMessageV3" + recordClazz);
        }
        return recordClazz;
    }

    public static SchemaInfo tableSchemaToSchemaInfo(String format, DataType dataType, Configuration configuration) throws IncompatibleSchemaException {
        switch (StringUtils.lowerCase((String)format)) {
            case "json": {
                return SchemaUtils.getSchemaInfo(SchemaType.JSON, dataType);
            }
            case "avro": {
                return SchemaUtils.getSchemaInfo(SchemaType.AVRO, dataType);
            }
            case "protobuf": {
                String messageClassName = (String)configuration.get(PbFormatOptions.MESSAGE_CLASS_NAME);
                return SchemaUtils.getProtobufSchemaInfo(messageClassName, SchemaUtils.class.getClassLoader());
            }
            case "atomic": {
                org.apache.pulsar.client.api.Schema pulsarSchema = SimpleSchemaTranslator.sqlType2PulsarSchema((DataType)dataType.getChildren().get(0));
                return pulsarSchema.getSchemaInfo();
            }
        }
        throw new UnsupportedOperationException("Generic schema is not supported on schema type " + dataType + "'");
    }

    private static <T extends GeneratedMessageV3> SchemaInfo getProtobufSchemaInfo(String messageClassName, ClassLoader classLoader) {
        try {
            org.apache.pulsar.client.api.Schema tSchema = org.apache.pulsar.client.api.Schema.PROTOBUF_NATIVE(SchemaUtils.convertProtobuf(classLoader.loadClass(messageClassName)));
            return tSchema.getSchemaInfo();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("not load Protobuf class: " + messageClassName, e);
        }
    }

    public static SchemaInfoImpl getSchemaInfo(SchemaType type, DataType dataType) {
        byte[] schemaBytes = SchemaUtils.getAvroSchema(dataType).toString().getBytes(StandardCharsets.UTF_8);
        return SchemaInfoImpl.builder().name("Record").schema(schemaBytes).type(type).properties(Collections.emptyMap()).build();
    }

    public static Schema getAvroSchema(DataType dataType) {
        Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)dataType.getLogicalType());
        if (schema.isNullable()) {
            schema = schema.getTypes().stream().filter(s -> s.getType() == Schema.Type.RECORD).findAny().orElseThrow(() -> new IllegalArgumentException("not support DataType: " + dataType.toString()));
        }
        return schema;
    }

    static {
        for (int i = 0; i < minBytesForPrecision.length; ++i) {
            SchemaUtils.minBytesForPrecision[i] = SchemaUtils.computeMinBytesForPrecision(i);
        }
    }
}

