/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum ParseMode {
    PERMISSIVE("PERMISSIVE"),
    DROPMALFORMED("DROPMALFORMED"),
    FAILFAST("FAILFAST");

    private String name;
    private static final Map<String, ParseMode> ENUM_MAP;

    private ParseMode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static ParseMode get(String name) {
        return ENUM_MAP.getOrDefault(name, PERMISSIVE);
    }

    static {
        ConcurrentHashMap<String, ParseMode> map = new ConcurrentHashMap<String, ParseMode>();
        for (ParseMode instance : ParseMode.values()) {
            map.put(instance.getName(), instance);
        }
        ENUM_MAP = Collections.unmodifiableMap(map);
    }
}

