/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.impl.schema.JSONSchema;

public class JsonSer<T>
implements SerializationSchema<T> {
    private final Class<T> recordClazz;
    private transient JSONSchema<T> pulsarSchema;

    private JsonSer(Class<T> recordClazz) {
        Preconditions.checkNotNull(recordClazz, (String)"JSON record class must not be null");
        this.recordClazz = recordClazz;
    }

    public static <T> JsonSer<T> of(Class<T> recordClazz) {
        return new JsonSer<T>(recordClazz);
    }

    public byte[] serialize(T message) {
        this.checkPulsarJsonSchemaInitialized();
        return this.pulsarSchema.encode(message);
    }

    private void checkPulsarJsonSchemaInitialized() {
        if (this.pulsarSchema != null) {
            return;
        }
        this.pulsarSchema = JSONSchema.of(this.recordClazz);
    }
}

