/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source;

import java.io.Serializable;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.pulsar.client.api.TypedMessageBuilder;

public interface MessageSerializer<T>
extends Serializable {
    public void serialize(T var1, TypedMessageBuilder<byte[]> var2);

    default public void open(SerializationSchema.InitializationContext context) throws Exception {
    }

    public static <V> MessageSerializer<V> valueOnly(final SerializationSchema<V> valueSerializer) {
        return new MessageSerializer<V>(){

            @Override
            public void open(SerializationSchema.InitializationContext context) throws Exception {
                valueSerializer.open(context);
            }

            @Override
            public void serialize(V element, TypedMessageBuilder<byte[]> messageBuilder) {
                messageBuilder.value((Object)valueSerializer.serialize(element));
            }
        };
    }
}

