/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.serialization;

import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.connectors.pulsar.SerializableFunction;
import org.apache.flink.streaming.connectors.pulsar.config.RecordSchemaType;
import org.apache.flink.streaming.connectors.pulsar.internal.IncompatibleSchemaException;
import org.apache.flink.streaming.connectors.pulsar.internal.SchemaTranslator;
import org.apache.flink.streaming.connectors.pulsar.internal.SchemaUtils;
import org.apache.flink.streaming.util.serialization.FlinkSchema;
import org.apache.flink.streaming.util.serialization.PulsarContextAware;
import org.apache.flink.streaming.util.serialization.PulsarSerializationSchema;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;

public class PulsarSerializationSchemaWrapper<T>
implements PulsarSerializationSchema<T>,
PulsarContextAware<T> {
    private final SerializationSchema<T> serializationSchema;
    private final RecordSchemaType recordSchemaType;
    private final Schema<?> schema;
    private final Class<?> clazz;
    private final DataType dataType;
    private final SchemaMode schemaMode;
    private final SerializableFunction<T, String> topicExtractor;
    private final SerializableFunction<T, byte[]> keyExtractor;
    private final SerializableFunction<T, Optional<Long>> deliverAtExtractor;

    private PulsarSerializationSchemaWrapper(SerializationSchema<T> serializationSchema, RecordSchemaType recordSchemaType, Class<?> clazz, Schema<?> schema, DataType dataType, SchemaMode schemaMode, SerializableFunction<T, String> topicExtractor, SerializableFunction<T, byte[]> keyExtractor, SerializableFunction<T, Optional<Long>> deliverAtExtractor) {
        this.serializationSchema = serializationSchema;
        this.recordSchemaType = recordSchemaType;
        this.schema = schema;
        this.clazz = clazz;
        this.dataType = dataType;
        this.schemaMode = (SchemaMode)((Object)Preconditions.checkNotNull((Object)((Object)schemaMode)));
        this.topicExtractor = topicExtractor;
        this.keyExtractor = keyExtractor;
        this.deliverAtExtractor = deliverAtExtractor;
    }

    public TypeInformation<T> getProducedType() {
        return null;
    }

    @Override
    public Optional<String> getTargetTopic(T element) {
        return Optional.ofNullable(this.topicExtractor.apply(element));
    }

    @Override
    public void serialize(T element, TypedMessageBuilder<T> messageBuilder) {
        if (this.keyExtractor != null) {
            messageBuilder.keyBytes((byte[])this.keyExtractor.apply(element));
        }
        if (this.deliverAtExtractor != null) {
            ((Optional)this.deliverAtExtractor.apply(element)).ifPresent(deliverAt -> messageBuilder.deliverAt(deliverAt.longValue()));
        }
        messageBuilder.value(element);
    }

    @Override
    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.serializationSchema.open(context);
    }

    @Override
    public Schema<T> getSchema() {
        try {
            switch (this.schemaMode) {
                case SPECIAL: {
                    Preconditions.checkNotNull(this.schema, (String)"The schema cannot be null in SPECIAL mode");
                    return new FlinkSchema<T>(this.schema.getSchemaInfo(), this.serializationSchema, null);
                }
                case ATOMIC: {
                    return new FlinkSchema<T>(SchemaTranslator.atomicType2PulsarSchema(this.dataType).getSchemaInfo(), this.serializationSchema, null);
                }
                case POJO: {
                    return new FlinkSchema<T>(SchemaUtils.buildSchemaForRecordClazz(this.clazz, this.recordSchemaType).getSchemaInfo(), this.serializationSchema, null);
                }
                case ROW: {
                    return new FlinkSchema<T>(SchemaUtils.buildRowSchema(this.dataType, this.recordSchemaType), this.serializationSchema, null);
                }
            }
        }
        catch (IncompatibleSchemaException e) {
            throw new IllegalStateException(e);
        }
        if (this.schema != null) {
            return new FlinkSchema<T>(this.schema.getSchemaInfo(), this.serializationSchema, null);
        }
        try {
            if (this.dataType instanceof AtomicDataType) {
                return new FlinkSchema<T>(SchemaTranslator.atomicType2PulsarSchema(this.dataType).getSchemaInfo(), this.serializationSchema, null);
            }
            Preconditions.checkNotNull(this.clazz, (String)"for non-atomic type, you must set clazz");
            Preconditions.checkNotNull((Object)((Object)this.recordSchemaType), (String)"for non-atomic type, you must set recordSchemaType");
            return new FlinkSchema<T>(SchemaUtils.buildRowSchema(this.dataType, this.recordSchemaType), this.serializationSchema, null);
        }
        catch (IncompatibleSchemaException e) {
            throw new RuntimeException(e);
        }
    }

    @PublicEvolving
    public static class Builder<T> {
        private final SerializationSchema<T> serializationSchema;
        private RecordSchemaType recordSchemaType;
        private Schema<?> schema;
        private Class<?> clazz;
        private DataType dataType;
        private SchemaMode mode;
        private SerializableFunction<T, String> topicExtractor = T -> null;
        private SerializableFunction<T, byte[]> keyExtractor;
        private SerializableFunction<T, Optional<Long>> deliverAtExtractor;

        public Builder(SerializationSchema<T> serializationSchema) {
            this.serializationSchema = serializationSchema;
        }

        public Builder<T> useSpecialMode(Schema<?> schema) {
            Preconditions.checkArgument((this.mode == null ? 1 : 0) != 0, (Object)"you can only set one schemaMode");
            this.mode = SchemaMode.SPECIAL;
            this.schema = schema;
            return this;
        }

        public Builder<T> useAtomicMode(DataType dataType) {
            Preconditions.checkArgument((this.mode == null ? 1 : 0) != 0, (Object)"you can only set one schemaMode");
            this.mode = SchemaMode.ATOMIC;
            Preconditions.checkArgument((boolean)(dataType instanceof AtomicDataType), (Object)"you must set an atomic dataType");
            this.dataType = dataType;
            return this;
        }

        public Builder<T> usePojoMode(Class<?> clazz, RecordSchemaType recordSchemaType) {
            Preconditions.checkArgument((this.mode == null ? 1 : 0) != 0, (Object)"you can only set one schemaMode");
            this.mode = SchemaMode.POJO;
            Preconditions.checkArgument((recordSchemaType != RecordSchemaType.ATOMIC ? 1 : 0) != 0, (Object)"cant ues RecordSchemaType.ATOMIC to build pojo type schema");
            this.clazz = clazz;
            this.recordSchemaType = recordSchemaType;
            return this;
        }

        public Builder<T> useRowMode(DataType dataType, RecordSchemaType recordSchemaType) {
            Preconditions.checkArgument((this.mode == null ? 1 : 0) != 0, (Object)"you can only set one schemaMode");
            this.mode = SchemaMode.ROW;
            this.dataType = dataType;
            this.recordSchemaType = recordSchemaType;
            return this;
        }

        public Builder<T> setTopicExtractor(SerializableFunction<T, String> topicExtractor) {
            this.topicExtractor = topicExtractor;
            return this;
        }

        public Builder<T> setKeyExtractor(SerializableFunction<T, byte[]> keyExtractor) {
            this.keyExtractor = keyExtractor;
            return this;
        }

        public Builder<T> setDeliverAtExtractor(SerializableFunction<T, Optional<Long>> deliverAtExtractor) {
            this.deliverAtExtractor = deliverAtExtractor;
            return this;
        }

        public PulsarSerializationSchemaWrapper<T> build() {
            Preconditions.checkNotNull((Object)((Object)this.mode), (String)"Must set mode use useSpecialMode or useAtomicMode or usePojoMode or useRowMode");
            return new PulsarSerializationSchemaWrapper(this.serializationSchema, this.recordSchemaType, this.clazz, this.schema, this.dataType, this.mode, this.topicExtractor, this.keyExtractor, this.deliverAtExtractor);
        }
    }

    static enum SchemaMode {
        ATOMIC,
        POJO,
        SPECIAL,
        ROW;

    }
}

