/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.serialization;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.SchemaInfo;

public class FlinkSchema<T>
implements Schema<T>,
Serializable {
    private final SchemaInfo schemaInfo;
    private final SerializationSchema<T> serializer;
    private final DeserializationSchema<T> deserializer;

    public FlinkSchema(SchemaInfo schemaInfo, SerializationSchema<T> serializer, DeserializationSchema<T> deserializer) {
        this.schemaInfo = schemaInfo;
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    public void validate(byte[] message) {
    }

    public byte[] encode(T t) {
        if (this.serializer == null) {
            throw new UnsupportedOperationException();
        }
        return this.serializer.serialize(t);
    }

    public T decode(byte[] bytes) {
        if (this.deserializer == null) {
            throw new UnsupportedOperationException();
        }
        try {
            return (T)this.deserializer.deserialize(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public Schema<T> clone() {
        return this;
    }
}

