/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarTopicState;
import org.apache.flink.streaming.connectors.pulsar.internal.TopicRange;

public class PulsarTopicStateWithPeriodicWatermarks<T>
extends PulsarTopicState {
    private final AssignerWithPeriodicWatermarks<T> timestampsAndWatermarks;
    private volatile long partitionWatermark;

    public PulsarTopicStateWithPeriodicWatermarks(String topic, AssignerWithPeriodicWatermarks<T> timestampsAndWatermarks) {
        super(topic);
        this.timestampsAndWatermarks = timestampsAndWatermarks;
        this.partitionWatermark = Long.MIN_VALUE;
    }

    public PulsarTopicStateWithPeriodicWatermarks(TopicRange topicRange, AssignerWithPeriodicWatermarks<T> timestampsAndWatermarks) {
        super(topicRange);
        this.timestampsAndWatermarks = timestampsAndWatermarks;
        this.partitionWatermark = Long.MIN_VALUE;
    }

    public long getTimestampForRecord(T record, long timestamp) {
        return this.timestampsAndWatermarks.extractTimestamp(record, timestamp);
    }

    public long getCurrentWatermarkTimestamp() {
        Watermark wm = this.timestampsAndWatermarks.getCurrentWatermark();
        if (wm != null) {
            this.partitionWatermark = Math.max(this.partitionWatermark, wm.getTimestamp());
        }
        return this.partitionWatermark;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic-range", (Object)this.getTopicRange()).add("offset", (Object)(this.isOffsetDefined() ? this.getOffset().toString() : "not set")).add("watermark", this.partitionWatermark).toString();
    }
}

