/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.connectors.pulsar.internal.ExceptionProxy;
import org.apache.flink.streaming.connectors.pulsar.internal.IncompatibleSchemaException;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarDeserializationSchema;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarFetcher;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarMetadataReader;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarTopicState;
import org.apache.flink.streaming.connectors.pulsar.internal.ReaderThread;
import org.apache.flink.streaming.connectors.pulsar.internal.RowReaderThread;
import org.apache.flink.streaming.connectors.pulsar.internal.TopicRange;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.types.Row;
import org.apache.flink.util.SerializedValue;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class PulsarRowFetcher
extends PulsarFetcher<Row> {
    private static final Logger log = LoggerFactory.getLogger(PulsarRowFetcher.class);
    private final boolean useExtendField;
    private final boolean usePulsarDeser;

    public PulsarRowFetcher(SourceFunction.SourceContext<Row> sourceContext, Map<TopicRange, MessageId> seedTopicsWithInitialOffsets, SerializedValue<AssignerWithPeriodicWatermarks<Row>> watermarksPeriodic, SerializedValue<AssignerWithPunctuatedWatermarks<Row>> watermarksPunctuated, ProcessingTimeService processingTimeProvider, long autoWatermarkInterval, ClassLoader userCodeClassLoader, StreamingRuntimeContext runtimeContext, ClientConfigurationData clientConf, Map<String, Object> readerConf, int pollTimeoutMs, PulsarDeserializationSchema<Row> deserializer, PulsarMetadataReader metadataReader, boolean useExtendField, boolean usePulsarDeser) throws Exception {
        super(sourceContext, seedTopicsWithInitialOffsets, watermarksPeriodic, watermarksPunctuated, processingTimeProvider, autoWatermarkInterval, userCodeClassLoader, runtimeContext, clientConf, readerConf, pollTimeoutMs, deserializer, metadataReader);
        this.useExtendField = useExtendField;
        this.usePulsarDeser = usePulsarDeser;
    }

    private SchemaInfo getPulsarSchema() {
        try {
            return this.metadataReader.getPulsarSchema(this.seedTopicsWithInitialOffsets.keySet().stream().map(TopicRange::getTopic).collect(Collectors.toList()));
        }
        catch (IncompatibleSchemaException e) {
            log.error("Incompatible schema encountered while read multi topics {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ReaderThread createReaderThread(ExceptionProxy exceptionProxy, PulsarTopicState state) {
        SchemaInfo schemaInfo = this.getPulsarSchema();
        return new RowReaderThread(this, state, this.clientConf, this.readerConf, this.pollTimeoutMs, schemaInfo, this.deserializer, exceptionProxy, this.useExtendField);
    }
}

