/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.connectors.pulsar.internal.ClosableBlockingQueue;
import org.apache.flink.streaming.connectors.pulsar.internal.ExceptionProxy;
import org.apache.flink.streaming.connectors.pulsar.internal.PoisonState;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarCommitCallback;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarDeserializationSchema;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarMetadataReader;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarTopicState;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarTopicStateWithPeriodicWatermarks;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarTopicStateWithPunctuatedWatermarks;
import org.apache.flink.streaming.connectors.pulsar.internal.ReaderThread;
import org.apache.flink.streaming.connectors.pulsar.internal.SourceSinkUtils;
import org.apache.flink.streaming.connectors.pulsar.internal.TopicRange;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeCallback;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.shade.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarFetcher<T> {
    private static final Logger log = LoggerFactory.getLogger(PulsarFetcher.class);
    private static final int NO_TIMESTAMPS_WATERMARKS = 0;
    private static final int PERIODIC_WATERMARKS = 1;
    private static final int PUNCTUATED_WATERMARKS = 2;
    protected final SourceFunction.SourceContext<T> sourceContext;
    protected final Map<TopicRange, MessageId> seedTopicsWithInitialOffsets;
    protected final Set<TopicRange> excludeStartMessageIds;
    private final Object checkpointLock;
    protected final List<PulsarTopicState> subscribedPartitionStates;
    protected final ClosableBlockingQueue<PulsarTopicState> unassignedPartitionsQueue;
    private final int timestampWatermarkMode;
    private final SerializedValue<AssignerWithPeriodicWatermarks<T>> watermarksPeriodic;
    private final SerializedValue<AssignerWithPunctuatedWatermarks<T>> watermarksPunctuated;
    private final ClassLoader userCodeClassLoader;
    private final StreamingRuntimeContext runtimeContext;
    protected final ClientConfigurationData clientConf;
    protected final Map<String, Object> readerConf;
    protected final PulsarDeserializationSchema<T> deserializer;
    protected final int pollTimeoutMs;
    private final int commitMaxRetries;
    protected final PulsarMetadataReader metadataReader;
    private volatile long maxWatermarkSoFar = Long.MIN_VALUE;
    private volatile boolean running = true;
    private Map<TopicRange, ReaderThread> topicToThread;
    private boolean failOnDataLoss = true;
    private boolean useEarliestWhenDataLoss;

    public PulsarFetcher(SourceFunction.SourceContext<T> sourceContext, Map<TopicRange, MessageId> seedTopicsWithInitialOffsets, SerializedValue<AssignerWithPeriodicWatermarks<T>> watermarksPeriodic, SerializedValue<AssignerWithPunctuatedWatermarks<T>> watermarksPunctuated, ProcessingTimeService processingTimeProvider, long autoWatermarkInterval, ClassLoader userCodeClassLoader, StreamingRuntimeContext runtimeContext, ClientConfigurationData clientConf, Map<String, Object> readerConf, int pollTimeoutMs, PulsarDeserializationSchema<T> deserializer, PulsarMetadataReader metadataReader) throws Exception {
        this(sourceContext, seedTopicsWithInitialOffsets, Collections.emptySet(), watermarksPeriodic, watermarksPunctuated, processingTimeProvider, autoWatermarkInterval, userCodeClassLoader, runtimeContext, clientConf, readerConf, pollTimeoutMs, 3, deserializer, metadataReader);
    }

    public PulsarFetcher(SourceFunction.SourceContext<T> sourceContext, Map<TopicRange, MessageId> seedTopicsWithInitialOffsets, Set<TopicRange> excludeStartMessageIds, SerializedValue<AssignerWithPeriodicWatermarks<T>> watermarksPeriodic, SerializedValue<AssignerWithPunctuatedWatermarks<T>> watermarksPunctuated, ProcessingTimeService processingTimeProvider, long autoWatermarkInterval, ClassLoader userCodeClassLoader, StreamingRuntimeContext runtimeContext, ClientConfigurationData clientConf, Map<String, Object> readerConf, int pollTimeoutMs, int commitMaxRetries, PulsarDeserializationSchema<T> deserializer, PulsarMetadataReader metadataReader) throws Exception {
        this.sourceContext = sourceContext;
        this.seedTopicsWithInitialOffsets = seedTopicsWithInitialOffsets;
        this.excludeStartMessageIds = excludeStartMessageIds;
        this.checkpointLock = sourceContext.getCheckpointLock();
        this.userCodeClassLoader = userCodeClassLoader;
        this.runtimeContext = runtimeContext;
        this.clientConf = clientConf;
        this.readerConf = readerConf == null ? new HashMap() : readerConf;
        this.failOnDataLoss = SourceSinkUtils.getFailOnDataLossAndRemoveKey(this.readerConf);
        this.useEarliestWhenDataLoss = SourceSinkUtils.getUseEarliestWhenDataLossAndRemoveKey(this.readerConf);
        this.pollTimeoutMs = pollTimeoutMs;
        this.commitMaxRetries = commitMaxRetries;
        this.deserializer = deserializer;
        this.metadataReader = metadataReader;
        this.watermarksPeriodic = watermarksPeriodic;
        this.watermarksPunctuated = watermarksPunctuated;
        if (watermarksPeriodic == null) {
            this.timestampWatermarkMode = watermarksPunctuated == null ? 0 : 2;
        } else if (watermarksPunctuated == null) {
            this.timestampWatermarkMode = 1;
        } else {
            throw new IllegalArgumentException("Cannot have both periodic and punctuated watermarks");
        }
        this.unassignedPartitionsQueue = new ClosableBlockingQueue();
        this.subscribedPartitionStates = this.createPartitionStateHolders(seedTopicsWithInitialOffsets, this.timestampWatermarkMode, watermarksPeriodic, watermarksPunctuated, userCodeClassLoader);
        for (PulsarTopicState state : this.subscribedPartitionStates) {
            if (state.isOffsetDefined()) continue;
            throw new IllegalArgumentException("The fetcher was assigned seed partitions with undefined initial offsets.");
        }
        for (PulsarTopicState state : this.subscribedPartitionStates) {
            this.unassignedPartitionsQueue.add(state);
        }
        if (this.timestampWatermarkMode == 1) {
            PeriodicWatermarkEmitter periodicEmitter = new PeriodicWatermarkEmitter(this.subscribedPartitionStates, sourceContext, processingTimeProvider, autoWatermarkInterval);
            periodicEmitter.start();
        }
    }

    public void runFetchLoop() throws Exception {
        this.topicToThread = new HashMap<TopicRange, ReaderThread>();
        ExceptionProxy exceptionProxy = new ExceptionProxy(Thread.currentThread());
        try {
            while (this.running) {
                exceptionProxy.checkAndThrowException();
                List<PulsarTopicState> topicsToAssign = this.unassignedPartitionsQueue.getBatchBlocking(5000L);
                topicsToAssign.removeIf(s -> s.equals(PoisonState.INSTANCE));
                if (!topicsToAssign.isEmpty()) {
                    if (!this.running) {
                        throw BreakingException.INSTANCE;
                    }
                    this.topicToThread.putAll(this.createAndStartReaderThread(topicsToAssign, exceptionProxy));
                } else {
                    this.topicToThread.values().removeIf(t -> !t.isRunning());
                }
                if (this.topicToThread.size() != 0 || !this.unassignedPartitionsQueue.isEmpty()) continue;
                PulsarTopicState topicForBlocking = this.unassignedPartitionsQueue.getElementBlocking();
                if (topicForBlocking.equals(PoisonState.INSTANCE)) {
                    throw BreakingException.INSTANCE;
                }
                this.topicToThread.putAll(this.createAndStartReaderThread((List<PulsarTopicState>)ImmutableList.of((Object)topicForBlocking), exceptionProxy));
            }
        }
        catch (BreakingException t2) {
        }
        catch (InterruptedException e) {
            exceptionProxy.checkAndThrowException();
            throw e;
        }
        finally {
            this.running = false;
            Thread.interrupted();
            try {
                int runningThreads = 0;
                do {
                    runningThreads = 0;
                    this.topicToThread.values().removeIf(s -> !s.isAlive());
                    for (ReaderThread t3 : this.topicToThread.values()) {
                        t3.cancel();
                        ++runningThreads;
                    }
                    if (runningThreads <= 0) continue;
                    for (ReaderThread t3 : this.topicToThread.values()) {
                        t3.join(500 / runningThreads + 1);
                    }
                } while (runningThreads > 0);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t4) {
                log.error("Exception while shutting down reader threads", t4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emitRecord(T record, PulsarTopicState topicState, MessageId offset) {
        if (record != null) {
            switch (this.timestampWatermarkMode) {
                case 0: {
                    Object object = this.checkpointLock;
                    synchronized (object) {
                        this.sourceContext.collect(record);
                        topicState.setOffset(offset);
                    }
                    return;
                }
                case 1: {
                    this.emitRecordWithTimestampAndPeriodicWatermark(record, topicState, offset, Long.MIN_VALUE);
                    return;
                }
                case 2: {
                    this.emitRecordWithTimestampAndPunctuatedWatermark(record, topicState, offset, Long.MIN_VALUE);
                    return;
                }
            }
        } else {
            Object object = this.checkpointLock;
            synchronized (object) {
                topicState.setOffset(offset);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitRecordWithTimestampAndPeriodicWatermark(T record, PulsarTopicState topicState, MessageId offset, long eventTimestamp) {
        PulsarTopicStateWithPeriodicWatermarks periodicState = (PulsarTopicStateWithPeriodicWatermarks)topicState;
        long timestamp = 0L;
        Object object = periodicState;
        synchronized (object) {
            timestamp = periodicState.getTimestampForRecord(record, eventTimestamp);
        }
        object = this.checkpointLock;
        synchronized (object) {
            this.sourceContext.collectWithTimestamp(record, timestamp);
            topicState.setOffset(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitRecordWithTimestampAndPunctuatedWatermark(T record, PulsarTopicState topicState, MessageId offset, long eventTimestamp) {
        PulsarTopicStateWithPunctuatedWatermarks punctuatedState = (PulsarTopicStateWithPunctuatedWatermarks)topicState;
        long timestamp = punctuatedState.getTimestampForRecord(record, eventTimestamp);
        Watermark newWM = punctuatedState.checkAndGetNewWatermark(record, timestamp);
        Object object = this.checkpointLock;
        synchronized (object) {
            this.sourceContext.collectWithTimestamp(record, timestamp);
            topicState.setOffset(offset);
        }
        if (newWM != null) {
            this.updateMinPunctuatedWatermark(newWM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMinPunctuatedWatermark(Watermark nextWatermark) {
        if (nextWatermark.getTimestamp() > this.maxWatermarkSoFar) {
            long newMin = Long.MAX_VALUE;
            for (PulsarTopicState state : this.subscribedPartitionStates) {
                PulsarTopicStateWithPunctuatedWatermarks puncState = (PulsarTopicStateWithPunctuatedWatermarks)state;
                newMin = Math.min(newMin, puncState.getCurrentPartitionWatermark());
            }
            if (newMin > this.maxWatermarkSoFar) {
                Object object = this.checkpointLock;
                synchronized (object) {
                    if (newMin > this.maxWatermarkSoFar) {
                        this.maxWatermarkSoFar = newMin;
                        this.sourceContext.emitWatermark(new Watermark(newMin));
                    }
                }
            }
        }
    }

    public void cancel() throws Exception {
        this.running = false;
        Set<TopicRange> topics = this.subscribedPartitionStates.stream().map(PulsarTopicState::getTopicRange).collect(Collectors.toSet());
        this.metadataReader.removeCursor(topics);
        this.unassignedPartitionsQueue.addIfOpen(PoisonState.INSTANCE);
    }

    public void commitOffsetToPulsar(Map<TopicRange, MessageId> offset, PulsarCommitCallback offsetCommitCallback) throws InterruptedException {
        this.doCommitOffsetToPulsar(this.removeEarliestAndLatest(offset), offsetCommitCallback);
    }

    public void doCommitOffsetToPulsar(Map<TopicRange, MessageId> offset, PulsarCommitCallback offsetCommitCallback) throws InterruptedException {
        try {
            int retries = 0;
            boolean success = false;
            while (this.running) {
                try {
                    this.metadataReader.commitCursorToOffset(offset);
                    success = true;
                    break;
                }
                catch (Exception e) {
                    log.warn("Failed to commit cursor to Pulsar.", (Throwable)e);
                    if (retries >= this.commitMaxRetries) {
                        log.error("Failed to commit cursor to Pulsar after {} attempts", (Object)retries);
                        throw e;
                    }
                    ++retries;
                    Thread.sleep(1000L);
                }
            }
            if (!success) {
                return;
            }
            offsetCommitCallback.onSuccess();
        }
        catch (Exception e) {
            if (this.running) {
                offsetCommitCallback.onException(e);
            }
            return;
        }
        for (PulsarTopicState state : this.subscribedPartitionStates) {
            MessageId off = offset.get(state.getTopicRange());
            if (off == null) continue;
            state.setCommittedOffset(off);
        }
    }

    public Map<TopicRange, MessageId> removeEarliestAndLatest(Map<TopicRange, MessageId> offset) {
        HashMap<TopicRange, MessageId> result = new HashMap<TopicRange, MessageId>();
        for (Map.Entry<TopicRange, MessageId> entry : offset.entrySet()) {
            MessageId mid = entry.getValue();
            if (mid.equals(MessageId.earliest) || mid.equals(MessageId.latest)) continue;
            result.put(entry.getKey(), mid);
        }
        return result;
    }

    public void addDiscoveredTopics(Set<TopicRange> newTopics) throws IOException, ClassNotFoundException {
        List<PulsarTopicState> newStates = this.createPartitionStateHolders(newTopics.stream().collect(Collectors.toMap(t -> t, t -> MessageId.earliest)), this.timestampWatermarkMode, this.watermarksPeriodic, this.watermarksPunctuated, this.userCodeClassLoader);
        for (PulsarTopicState state : newStates) {
            this.subscribedPartitionStates.add(state);
            this.unassignedPartitionsQueue.add(state);
        }
    }

    public Map<TopicRange, MessageId> snapshotCurrentState() {
        assert (Thread.holdsLock(this.checkpointLock));
        HashMap<TopicRange, MessageId> state = new HashMap<TopicRange, MessageId>(this.subscribedPartitionStates.size());
        for (PulsarTopicState pa : this.subscribedPartitionStates) {
            state.put(pa.getTopicRange(), pa.getOffset());
        }
        return state;
    }

    public Map<TopicRange, ReaderThread> createAndStartReaderThread(List<PulsarTopicState> states, ExceptionProxy exceptionProxy) {
        Map<TopicRange, MessageId> startingOffsets = states.stream().collect(Collectors.toMap(PulsarTopicState::getTopicRange, PulsarTopicState::getOffset));
        this.metadataReader.setupCursor(startingOffsets, this.failOnDataLoss);
        HashMap<TopicRange, ReaderThread> topic2Threads = new HashMap<TopicRange, ReaderThread>();
        for (PulsarTopicState state : states) {
            ReaderThread readerT = this.createReaderThread(exceptionProxy, state);
            readerT.setName(String.format("Pulsar Reader for %s in task %s", state.getTopicRange(), this.runtimeContext.getTaskName()));
            readerT.setDaemon(true);
            readerT.start();
            log.info("Starting Thread {}", (Object)readerT.getName());
            topic2Threads.put(state.getTopicRange(), readerT);
        }
        return topic2Threads;
    }

    protected List<PulsarTopicState> getSubscribedTopicStates() {
        return this.subscribedPartitionStates;
    }

    protected ReaderThread createReaderThread(ExceptionProxy exceptionProxy, PulsarTopicState state) {
        return new ReaderThread<T>(this, state, this.clientConf, this.readerConf, this.deserializer, this.pollTimeoutMs, exceptionProxy, this.failOnDataLoss, this.useEarliestWhenDataLoss, this.excludeStartMessageIds.contains(state.getTopicRange()));
    }

    private List<PulsarTopicState> createPartitionStateHolders(Map<TopicRange, MessageId> partitionsToInitialOffsets, int timestampWatermarkMode, SerializedValue<AssignerWithPeriodicWatermarks<T>> watermarksPeriodic, SerializedValue<AssignerWithPunctuatedWatermarks<T>> watermarksPunctuated, ClassLoader userCodeClassLoader) throws IOException, ClassNotFoundException {
        CopyOnWriteArrayList<PulsarTopicState> partitionStates = new CopyOnWriteArrayList<PulsarTopicState>();
        switch (timestampWatermarkMode) {
            case 0: {
                for (Map.Entry<TopicRange, MessageId> partitionEntry : partitionsToInitialOffsets.entrySet()) {
                    PulsarTopicState state = new PulsarTopicState(partitionEntry.getKey());
                    state.setOffset(partitionEntry.getValue());
                    partitionStates.add(state);
                }
                return partitionStates;
            }
            case 1: {
                for (Map.Entry<TopicRange, MessageId> partitionEntry : partitionsToInitialOffsets.entrySet()) {
                    AssignerWithPeriodicWatermarks assignerInstance = (AssignerWithPeriodicWatermarks)watermarksPeriodic.deserializeValue(userCodeClassLoader);
                    PulsarTopicStateWithPeriodicWatermarks state = new PulsarTopicStateWithPeriodicWatermarks(partitionEntry.getKey(), assignerInstance);
                    state.setOffset(partitionEntry.getValue());
                    partitionStates.add(state);
                }
                return partitionStates;
            }
            case 2: {
                for (Map.Entry<TopicRange, MessageId> partitionEntry : partitionsToInitialOffsets.entrySet()) {
                    AssignerWithPunctuatedWatermarks assignerInstance = (AssignerWithPunctuatedWatermarks)watermarksPunctuated.deserializeValue(userCodeClassLoader);
                    PulsarTopicStateWithPunctuatedWatermarks state = new PulsarTopicStateWithPunctuatedWatermarks(partitionEntry.getKey(), assignerInstance);
                    state.setOffset(partitionEntry.getValue());
                    partitionStates.add(state);
                }
                return partitionStates;
            }
        }
        throw new RuntimeException();
    }

    public PulsarMetadataReader getMetaDataReader() {
        return this.metadataReader;
    }

    private static class BreakingException
    extends Exception {
        static final BreakingException INSTANCE = new BreakingException();

        private BreakingException() {
        }
    }

    private static class PeriodicWatermarkEmitter
    implements ProcessingTimeCallback {
        private final List<PulsarTopicState> allPartitions;
        private final SourceFunction.SourceContext<?> emitter;
        private final ProcessingTimeService timerService;
        private final long interval;
        private long lastWatermarkTimestamp;

        PeriodicWatermarkEmitter(List<PulsarTopicState> allPartitions, SourceFunction.SourceContext<?> emitter, ProcessingTimeService timerService, long autoWatermarkInterval) {
            this.allPartitions = (List)Preconditions.checkNotNull(allPartitions);
            this.emitter = (SourceFunction.SourceContext)Preconditions.checkNotNull(emitter);
            this.timerService = (ProcessingTimeService)Preconditions.checkNotNull((Object)timerService);
            this.interval = autoWatermarkInterval;
            this.lastWatermarkTimestamp = Long.MIN_VALUE;
        }

        public void start() {
            this.timerService.registerTimer(this.timerService.getCurrentProcessingTime() + this.interval, (ProcessingTimeCallback)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProcessingTime(long timestamp) throws Exception {
            long minAcrossAll = Long.MAX_VALUE;
            boolean isEffectiveMinAggregation = false;
            Iterator<PulsarTopicState> iterator = this.allPartitions.iterator();
            while (iterator.hasNext()) {
                long curr;
                PulsarTopicState state;
                PulsarTopicState pulsarTopicState = state = iterator.next();
                synchronized (pulsarTopicState) {
                    curr = ((PulsarTopicStateWithPeriodicWatermarks)state).getCurrentWatermarkTimestamp();
                }
                minAcrossAll = Math.min(minAcrossAll, curr);
                isEffectiveMinAggregation = true;
            }
            if (isEffectiveMinAggregation && minAcrossAll > this.lastWatermarkTimestamp) {
                this.lastWatermarkTimestamp = minAcrossAll;
                this.emitter.emitWatermark(new Watermark(minAcrossAll));
            }
            this.timerService.registerTimer(this.timerService.getCurrentProcessingTime() + this.interval, (ProcessingTimeCallback)this);
        }
    }
}

