/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarDeserializationSchema;
import org.apache.pulsar.client.api.Message;

@Internal
public class PulsarDeserializationSchemaWrapper<T>
implements PulsarDeserializationSchema<T> {
    private static final long serialVersionUID = 2651665280744549932L;
    private final DeserializationSchema<T> deserializationSchema;

    public PulsarDeserializationSchemaWrapper(DeserializationSchema<T> deserializationSchema) {
        this.deserializationSchema = deserializationSchema;
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.deserializationSchema.open(context);
    }

    @Override
    public boolean isEndOfStream(T nextElement) {
        return this.deserializationSchema.isEndOfStream(nextElement);
    }

    @Override
    public T deserialize(Message message) throws IOException {
        return (T)this.deserializationSchema.deserialize(message.getData());
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }
}

