/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.atomic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.connectors.pulsar.internal.IncompatibleSchemaException;
import org.apache.flink.streaming.connectors.pulsar.internal.SimpleSchemaTranslator;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.pulsar.client.api.Schema;

public class AtomicRowDeserializationSchema
implements DeserializationSchema<Row> {
    private static final long serialVersionUID = -228294330688809195L;
    private final String className;
    private final boolean useExtendFields;
    private final Class<?> clazz;

    public AtomicRowDeserializationSchema(String className, boolean useExtendFields) {
        this.className = className;
        this.useExtendFields = useExtendFields;
        try {
            this.clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isUseExtendFields() {
        return this.useExtendFields;
    }

    public Row deserialize(byte[] message) throws IOException {
        DataType dataType = (DataType)TypeConversions.fromClassToDataType(this.clazz).orElseThrow(() -> new IllegalStateException(this.clazz.getCanonicalName() + "cant cast to flink dataType"));
        try {
            Schema schema = SimpleSchemaTranslator.sqlType2PulsarSchema(dataType);
            Object data = schema.decode(message);
            Row row = new Row(1);
            row.setField(0, data);
            return row;
        }
        catch (IncompatibleSchemaException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEndOfStream(Row nextElement) {
        return false;
    }

    public TypeInformation<Row> getProducedType() {
        FieldsDataType fieldsDataType;
        ArrayList<DataTypes.Field> mainSchema = new ArrayList<DataTypes.Field>();
        DataType dataType = (DataType)TypeConversions.fromClassToDataType(this.clazz).orElseThrow(() -> new IllegalStateException(this.clazz.getCanonicalName() + "cant cast to flink dataType"));
        if (dataType instanceof FieldsDataType) {
            fieldsDataType = (FieldsDataType)dataType;
            RowType rowType = (RowType)fieldsDataType.getLogicalType();
            List fieldNames = rowType.getFieldNames();
            for (int i = 0; i < fieldNames.size(); ++i) {
                LogicalType logicalType = rowType.getTypeAt(i);
                DataTypes.Field field = DataTypes.FIELD((String)((String)fieldNames.get(i)), (DataType)TypeConversions.fromLogicalToDataType((LogicalType)logicalType));
                mainSchema.add(field);
            }
        } else {
            mainSchema.add(DataTypes.FIELD((String)"value", (DataType)dataType));
        }
        if (this.useExtendFields) {
            mainSchema.addAll(SimpleSchemaTranslator.METADATA_FIELDS);
        }
        fieldsDataType = (FieldsDataType)DataTypes.ROW((DataTypes.Field[])mainSchema.toArray(new DataTypes.Field[0]));
        return TypeConversions.fromDataTypeToLegacyInfo((DataType)fieldsDataType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtomicRowDeserializationSchema that = (AtomicRowDeserializationSchema)o;
        if (this.useExtendFields != that.useExtendFields) {
            return false;
        }
        return this.className.equals(that.className);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = 31 * result + (this.useExtendFields ? 1 : 0);
        return result;
    }

    public static class Builder<T> {
        private final String className;
        private boolean useExtendFields;

        public Builder(String className) {
            this.className = className;
        }

        public Builder useExtendFields(boolean useExtendFields) {
            this.useExtendFields = useExtendFields;
            return this;
        }

        public AtomicRowDeserializationSchema build() {
            return new AtomicRowDeserializationSchema(this.className, this.useExtendFields);
        }
    }
}

