/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.subscription;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.connector.pulsar.source.AbstractPartition;
import org.apache.flink.connector.pulsar.source.PulsarSubscriber;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPulsarSubscriber
extends PulsarSubscriber {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public PulsarSubscriber.PartitionChange getPartitionChanges(PulsarAdmin pulsarAdmin, Set<AbstractPartition> currentAssignment) throws PulsarAdminException, InterruptedException, IOException {
        HashSet<AbstractPartition> newPartitions = new HashSet<AbstractPartition>();
        HashSet<AbstractPartition> removedPartitions = new HashSet<AbstractPartition>(currentAssignment);
        for (AbstractPartition partition : this.getCurrentPartitions(pulsarAdmin)) {
            if (removedPartitions.remove(partition)) continue;
            newPartitions.add(partition);
        }
        if (!removedPartitions.isEmpty()) {
            this.logger.warn("The following partitions have been removed from the Pulsar cluster. {}", removedPartitions);
        }
        if (!newPartitions.isEmpty()) {
            this.logger.info("The following partitions have been added to the Pulsar cluster. {}", newPartitions);
        }
        return new PulsarSubscriber.PartitionChange(newPartitions, removedPartitions);
    }

    protected abstract Collection<AbstractPartition> getCurrentPartitions(PulsarAdmin var1) throws PulsarAdminException, InterruptedException, IOException;
}

