/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.pulsar.factories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.pulsar.PulsarCatalog;
import org.apache.flink.table.catalog.pulsar.PulsarCatalogValidator;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.CatalogFactory;

public class PulsarCatalogFactory
implements CatalogFactory {
    public Catalog createCatalog(String name, Map<String, String> properties) {
        DescriptorProperties dp = this.getValidateProperties(properties);
        String defaultDB = dp.getOptionalString("default-database").orElse("public/default");
        String adminUrl = dp.getString("admin-url");
        return new PulsarCatalog(adminUrl, name, dp.asMap(), defaultDB);
    }

    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("type", "pulsar");
        context.put("property-version", "1");
        return context;
    }

    public List<String> supportedProperties() {
        ArrayList<String> props = new ArrayList<String>();
        props.add("default-database");
        props.add("pulsar-version");
        props.add("service-url");
        props.add("admin-url");
        props.add("startup-mode");
        props.add("table-default-partitions");
        props.add("format.*");
        return props;
    }

    private DescriptorProperties getValidateProperties(Map<String, String> properties) {
        DescriptorProperties dp = new DescriptorProperties();
        dp.putProperties(properties);
        new PulsarCatalogValidator().validate(dp);
        return dp;
    }
}

