/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.pulsar;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.CatalogDescriptorValidator;
import org.apache.flink.table.descriptors.DescriptorProperties;

public class PulsarCatalogValidator
extends CatalogDescriptorValidator {
    public static final String CATALOG_TYPE_VALUE_PULSAR = "pulsar";
    public static final String CATALOG_PULSAR_VERSION = "pulsar-version";
    public static final String CATALOG_SERVICE_URL = "service-url";
    public static final String CATALOG_ADMIN_URL = "admin-url";
    public static final String CATALOG_STARTUP_MODE = "startup-mode";
    public static final String CATALOG_DEFAULT_PARTITIONS = "table-default-partitions";

    public void validate(DescriptorProperties properties) {
        super.validate(properties);
        properties.validateValue("type", CATALOG_TYPE_VALUE_PULSAR, false);
        properties.validateString(CATALOG_PULSAR_VERSION, true, 1);
        properties.validateString(CATALOG_SERVICE_URL, false, 1);
        properties.validateString(CATALOG_ADMIN_URL, false, 1);
        properties.validateInt(CATALOG_DEFAULT_PARTITIONS, true, 1);
        properties.validateString("format.type", false);
        this.validateStartingOffsets(properties);
    }

    private void validateStartingOffsets(DescriptorProperties properties) {
        String v;
        if (properties.containsKey(CATALOG_STARTUP_MODE) && !(v = properties.getString(CATALOG_STARTUP_MODE)).equals("earliest") && !v.equals("latest")) {
            throw new ValidationException("startup-mode should be either earliest or latest");
        }
    }
}

