/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.pulsar;

import java.util.Map;
import org.apache.flink.table.descriptors.CatalogDescriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class PulsarCatalogDescriptor
extends CatalogDescriptor {
    private String pulsarVersion;

    public PulsarCatalogDescriptor() {
        super("pulsar", 1, "public/default");
    }

    public PulsarCatalogDescriptor pulsarVersion(String pulsarVersion) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)pulsarVersion) ? 1 : 0) != 0);
        this.pulsarVersion = pulsarVersion;
        return this;
    }

    protected Map<String, String> toCatalogProperties() {
        DescriptorProperties props = new DescriptorProperties();
        if (this.pulsarVersion != null) {
            props.putString("pulsar-version", this.pulsarVersion);
        }
        return props.asMap();
    }
}

