/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarOptions;
import org.apache.flink.streaming.connectors.pulsar.internal.SerializableRange;
import org.apache.flink.streaming.connectors.pulsar.internal.TopicRange;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class SourceSinkUtils {
    public static Map<String, String> validateStreamSourceOptions(Map<String, String> parameters) {
        Map<String, String> caseInsensitiveParams = parameters.entrySet().stream().collect(Collectors.toMap(t -> ((String)t.getKey()).toLowerCase(Locale.ROOT), t -> (String)t.getValue()));
        return SourceSinkUtils.validateSourceOptions(caseInsensitiveParams);
    }

    private static Map<String, String> validateSourceOptions(Map<String, String> caseInsensitiveParams) {
        Map<String, String> topicOptions = caseInsensitiveParams.entrySet().stream().filter(t -> PulsarOptions.TOPIC_OPTION_KEYS.contains(t.getKey())).collect(Collectors.toMap(map -> (String)map.getKey(), map -> (String)map.getValue()));
        if (topicOptions.isEmpty() || topicOptions.size() > 1) {
            throw new IllegalArgumentException("You should specify topic(s) using one of the topic options: " + StringUtils.join(PulsarOptions.TOPIC_OPTION_KEYS, (String)","));
        }
        for (Map.Entry<String, String> topicEntry : topicOptions.entrySet()) {
            String key = topicEntry.getKey();
            String value = topicEntry.getValue();
            if (key.equals("topic")) {
                if (!value.contains(",")) continue;
                throw new IllegalArgumentException("Use `topics` instead of `topic` for multi topic read");
            }
            if (key.equals("topics")) {
                List topics = Arrays.asList(value.split(",")).stream().map(String::trim).filter(t -> !t.isEmpty()).collect(Collectors.toList());
                if (!topics.isEmpty()) continue;
                throw new IllegalArgumentException("No topics is specified for read with option" + value);
            }
            if (value.trim().length() != 0) continue;
            throw new IllegalArgumentException("TopicsPattern is empty");
        }
        return caseInsensitiveParams;
    }

    public static boolean belongsTo(TopicRange topicRange, int numParallelSubtasks, int index) {
        String topic = topicRange.getTopic();
        if (topic.contains("-partition-")) {
            int pos = topic.lastIndexOf("-partition-");
            String topicPrefix = topic.substring(0, pos);
            String topicPartitionIndex = topic.substring(pos + "-partition-".length());
            if (topicPartitionIndex.matches("0|[1-9]\\d*")) {
                int startIndex = (topicPrefix.hashCode() * 31 & Integer.MAX_VALUE) % numParallelSubtasks;
                return (startIndex + Integer.valueOf(topicPartitionIndex)) % numParallelSubtasks == index;
            }
        }
        return (topic.hashCode() * 31 & Integer.MAX_VALUE) % numParallelSubtasks == index;
    }

    public static long getPartitionDiscoveryIntervalInMillis(Map<String, String> parameters) {
        String interval = parameters.getOrDefault("partitiondiscoveryintervalmillis", "-1");
        return Long.parseLong(interval);
    }

    public static int getPollTimeoutMs(Map<String, String> parameters) {
        String interval = parameters.getOrDefault("polltimeoutms", "120000");
        return Integer.parseInt(interval);
    }

    public static int getCommitMaxRetries(Map<String, String> parameters) {
        String retries = parameters.getOrDefault("commitmaxretries", "3");
        return Integer.parseInt(retries);
    }

    public static int getClientCacheSize(Map<String, String> parameters) {
        String size = parameters.getOrDefault("clientcachesize", "5");
        return Integer.parseInt(size);
    }

    public static boolean flushOnCheckpoint(Map<String, String> parameters) {
        String b = parameters.getOrDefault("flushoncheckpoint", "true");
        return Boolean.parseBoolean(b);
    }

    public static boolean failOnWrite(Map<String, String> parameters) {
        String b = parameters.getOrDefault("failonwrite", "false");
        return Boolean.parseBoolean(b);
    }

    public static Map<String, Object> getReaderParams(Map<String, String> parameters) {
        return parameters.keySet().stream().filter(k -> k.startsWith("pulsar.reader.")).collect(Collectors.toMap(k -> k.substring("pulsar.reader.".length()), k -> (String)parameters.get(k)));
    }

    public static Map<String, String> toCaceInsensitiveParams(Map<String, String> parameters) {
        return parameters.entrySet().stream().collect(Collectors.toMap(t -> ((String)t.getKey()).toLowerCase(Locale.ROOT), t -> (String)t.getValue()));
    }

    public static Map<String, Object> getProducerParams(Map<String, String> parameters) {
        return parameters.keySet().stream().filter(k -> k.startsWith("pulsar.producer.")).collect(Collectors.toMap(k -> k.substring("pulsar.producer.".length()), k -> (String)parameters.get(k)));
    }

    public static Range distributeRange(int countOfSubTasks, int indexOfSubTasks) {
        int subTasksEndKey;
        int subTasksStartKey;
        int countOfKey = SerializableRange.fullRangeEnd + 1;
        int part = countOfKey / countOfSubTasks;
        int remainder = countOfKey % countOfSubTasks;
        if (indexOfSubTasks < remainder) {
            subTasksStartKey = indexOfSubTasks * ++part;
            subTasksEndKey = indexOfSubTasks * part + part;
        } else {
            subTasksStartKey = indexOfSubTasks * part + remainder;
            subTasksEndKey = indexOfSubTasks * part + part + remainder;
        }
        return Range.of((int)subTasksStartKey, (int)(--subTasksEndKey));
    }

    public static int getOldStateVersion(Map<String, String> caseInsensitiveParams) {
        String value = caseInsensitiveParams.get("old-state-version");
        if (StringUtils.isBlank((CharSequence)value)) {
            return 0;
        }
        return Integer.parseInt(value);
    }
}

