/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.streaming.connectors.pulsar.internal.IncompatibleSchemaException;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarOptions;
import org.apache.flink.streaming.connectors.pulsar.internal.SchemaTranslator;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.shade.org.apache.avro.LogicalTypes;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.SchemaBuilder;

public class SimpleSchemaTranslator
extends SchemaTranslator {
    private final boolean useExtendField;
    private static final Schema NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
    private static int[] minBytesForPrecision = new int[39];
    public static final List<DataTypes.Field> METADATA_FIELDS;

    public SimpleSchemaTranslator() {
        this.useExtendField = false;
    }

    public SimpleSchemaTranslator(boolean useExtendField) {
        this.useExtendField = useExtendField;
    }

    @Override
    public SchemaInfo tableSchemaToPulsarSchema(TableSchema tableSchema) throws IncompatibleSchemaException {
        DataType dataType;
        ArrayList<String> fieldsRemaining = new ArrayList<String>(tableSchema.getFieldCount());
        for (String fieldName : tableSchema.getFieldNames()) {
            if (PulsarOptions.META_FIELD_NAMES.contains(fieldName)) continue;
            fieldsRemaining.add(fieldName);
        }
        if (fieldsRemaining.size() == 1) {
            dataType = (DataType)tableSchema.getFieldDataType((String)fieldsRemaining.get(0)).get();
        } else {
            List<DataTypes.Field> fieldList = fieldsRemaining.stream().map(f -> DataTypes.FIELD((String)f, (DataType)((DataType)tableSchema.getFieldDataType(f).get()))).collect(Collectors.toList());
            dataType = DataTypes.ROW((DataTypes.Field[])fieldList.toArray(new DataTypes.Field[0]));
        }
        return SimpleSchemaTranslator.sqlType2PulsarSchema(dataType).getSchemaInfo();
    }

    public static org.apache.pulsar.client.api.Schema sqlType2PulsarSchema(DataType flinkType) throws IncompatibleSchemaException {
        if (flinkType instanceof AtomicDataType) {
            return SimpleSchemaTranslator.atomicType2PulsarSchema(flinkType);
        }
        if (flinkType instanceof FieldsDataType) {
            return SimpleSchemaTranslator.avroSchema2PulsarSchema(SimpleSchemaTranslator.sqlType2AvroSchema(flinkType));
        }
        throw new IncompatibleSchemaException(String.format("%s is not supported by Pulsar yet", flinkType.toString()), null);
    }

    static GenericSchema<GenericRecord> avroSchema2PulsarSchema(Schema avroSchema) {
        byte[] schemaBytes = avroSchema.toString().getBytes(StandardCharsets.UTF_8);
        SchemaInfo si = new SchemaInfo();
        si.setName("Avro");
        si.setSchema(schemaBytes);
        si.setType(SchemaType.AVRO);
        return org.apache.pulsar.client.api.Schema.generic((SchemaInfo)si);
    }

    public static Schema sqlType2AvroSchema(DataType flinkType) throws IncompatibleSchemaException {
        return SimpleSchemaTranslator.sqlType2AvroSchema(flinkType, false, "topLevelRecord", "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Schema sqlType2AvroSchema(DataType flinkType, boolean nullable, String recordName, String namespace) throws IncompatibleSchemaException {
        Schema schema;
        block19: {
            LogicalTypeRoot type;
            SchemaBuilder.TypeBuilder builder;
            block18: {
                builder = SchemaBuilder.builder();
                type = flinkType.getLogicalType().getTypeRoot();
                schema = null;
                if (!(flinkType instanceof AtomicDataType)) break block18;
                switch (type) {
                    case BOOLEAN: {
                        schema = (Schema)builder.booleanType();
                        break block19;
                    }
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: {
                        schema = (Schema)builder.intType();
                        break block19;
                    }
                    case BIGINT: {
                        schema = (Schema)builder.longType();
                        break block19;
                    }
                    case DATE: {
                        schema = LogicalTypes.date().addToSchema((Schema)builder.intType());
                        break block19;
                    }
                    case TIMESTAMP_WITHOUT_TIME_ZONE: {
                        schema = LogicalTypes.timestampMicros().addToSchema((Schema)builder.longType());
                        break block19;
                    }
                    case FLOAT: {
                        schema = (Schema)builder.floatType();
                        break block19;
                    }
                    case DOUBLE: {
                        schema = (Schema)builder.doubleType();
                        break block19;
                    }
                    case VARCHAR: {
                        schema = (Schema)builder.stringType();
                        break block19;
                    }
                    case BINARY: 
                    case VARBINARY: {
                        schema = (Schema)builder.bytesType();
                        break block19;
                    }
                    case DECIMAL: {
                        DecimalType dt = (DecimalType)flinkType.getLogicalType();
                        LogicalTypes.Decimal avroType = LogicalTypes.decimal((int)dt.getPrecision(), (int)dt.getScale());
                        int fixedSize = minBytesForPrecision[dt.getPrecision()];
                        String name = namespace.equals("") ? recordName + ".fixed" : namespace + recordName + ".fixed";
                        schema = avroType.addToSchema((Schema)SchemaBuilder.fixed((String)name).size(fixedSize));
                        break block19;
                    }
                    default: {
                        throw new IncompatibleSchemaException(String.format("Unsupported type %s", flinkType.toString()), null);
                    }
                }
            }
            if (flinkType instanceof CollectionDataType) {
                if (type != LogicalTypeRoot.ARRAY) throw new IncompatibleSchemaException("Pulsar only support collection as array", null);
                CollectionDataType cdt = (CollectionDataType)flinkType;
                DataType elementType = cdt.getElementDataType();
                schema = (Schema)builder.array().items(SimpleSchemaTranslator.sqlType2AvroSchema(elementType, elementType.getLogicalType().isNullable(), recordName, namespace));
            } else if (flinkType instanceof KeyValueDataType) {
                KeyValueDataType kvType = (KeyValueDataType)flinkType;
                DataType keyType = kvType.getKeyDataType();
                DataType valueType = kvType.getValueDataType();
                if (!(keyType instanceof AtomicDataType) || keyType.getLogicalType().getTypeRoot() != LogicalTypeRoot.VARCHAR) {
                    throw new IncompatibleSchemaException("Pulsar only support string key map", null);
                }
                schema = (Schema)builder.map().values(SimpleSchemaTranslator.sqlType2AvroSchema(valueType, valueType.getLogicalType().isNullable(), recordName, namespace));
            } else {
                if (!(flinkType instanceof FieldsDataType)) throw new IncompatibleSchemaException(String.format("Unexpected type %s", flinkType.toString()), null);
                FieldsDataType fieldsDataType = (FieldsDataType)flinkType;
                String childNamespace = namespace.equals("") ? recordName : namespace + "." + recordName;
                SchemaBuilder.FieldAssembler fieldsAssembler = ((SchemaBuilder.RecordBuilder)builder.record(recordName).namespace(namespace)).fields();
                RowType rowType = (RowType)fieldsDataType.getLogicalType();
                List filedNames = rowType.getFieldNames();
                for (int i = 0; i < filedNames.size(); ++i) {
                    String fieldName = (String)filedNames.get(i);
                    LogicalType logicalType = rowType.getTypeAt(i);
                    DataType ftype = TypeConversions.fromLogicalToDataType((LogicalType)logicalType);
                    Schema fieldAvroSchema = SimpleSchemaTranslator.sqlType2AvroSchema(ftype, ftype.getLogicalType().isNullable(), fieldName, childNamespace);
                    fieldsAssembler.name(fieldName).type(fieldAvroSchema).noDefault();
                }
                schema = (Schema)fieldsAssembler.endRecord();
            }
        }
        if (!nullable) return schema;
        return Schema.createUnion((Schema[])new Schema[]{schema, NULL_SCHEMA});
    }

    public static SchemaInfo emptySchemaInfo() {
        return SchemaInfo.builder().name("empty").type(SchemaType.NONE).schema(new byte[0]).build();
    }

    private static int computeMinBytesForPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }

    @Override
    public TableSchema pulsarSchemaToTableSchema(SchemaInfo pulsarSchema) throws IncompatibleSchemaException {
        FieldsDataType fieldsDataType = this.pulsarSchemaToFieldsDataType(pulsarSchema);
        RowType rt = (RowType)fieldsDataType.getLogicalType();
        List fieldTypes = fieldsDataType.getChildren();
        return TableSchema.builder().fields(rt.getFieldNames().toArray(new String[0]), fieldTypes.toArray(new DataType[0])).build();
    }

    @Override
    public FieldsDataType pulsarSchemaToFieldsDataType(SchemaInfo schemaInfo) throws IncompatibleSchemaException {
        ArrayList<DataTypes.Field> mainSchema = new ArrayList<DataTypes.Field>();
        DataType dataType = this.schemaInfo2SqlType(schemaInfo);
        if (dataType instanceof FieldsDataType) {
            FieldsDataType fieldsDataType = (FieldsDataType)dataType;
            RowType rowType = (RowType)fieldsDataType.getLogicalType();
            List fieldNames = rowType.getFieldNames();
            for (int i = 0; i < fieldNames.size(); ++i) {
                LogicalType logicalType = rowType.getTypeAt(i);
                DataTypes.Field field = DataTypes.FIELD((String)((String)fieldNames.get(i)), (DataType)TypeConversions.fromLogicalToDataType((LogicalType)logicalType));
                mainSchema.add(field);
            }
        } else {
            mainSchema.add(DataTypes.FIELD((String)"value", (DataType)dataType));
        }
        if (this.useExtendField) {
            mainSchema.addAll(METADATA_FIELDS);
        }
        return (FieldsDataType)DataTypes.ROW((DataTypes.Field[])mainSchema.toArray(new DataTypes.Field[0]));
    }

    @Override
    public DataType schemaInfo2SqlType(SchemaInfo si) throws IncompatibleSchemaException {
        switch (si.getType()) {
            case NONE: 
            case BYTES: {
                return DataTypes.BYTES();
            }
            case BOOLEAN: {
                return DataTypes.BOOLEAN();
            }
            case LOCAL_DATE: {
                return DataTypes.DATE();
            }
            case LOCAL_TIME: {
                return DataTypes.TIME();
            }
            case STRING: {
                return DataTypes.STRING();
            }
            case LOCAL_DATE_TIME: {
                return DataTypes.TIMESTAMP((int)3);
            }
            case INT8: {
                return DataTypes.TINYINT();
            }
            case DOUBLE: {
                return DataTypes.DOUBLE();
            }
            case FLOAT: {
                return DataTypes.FLOAT();
            }
            case INT32: {
                return DataTypes.INT();
            }
            case INT64: {
                return DataTypes.BIGINT();
            }
            case INT16: {
                return DataTypes.SMALLINT();
            }
            case AVRO: 
            case JSON: {
                Schema avroSchema = new Schema.Parser().parse(new String(si.getSchema(), StandardCharsets.UTF_8));
                return SimpleSchemaTranslator.avro2SqlType(avroSchema, Collections.emptySet());
            }
        }
        throw new UnsupportedOperationException(String.format("We do not support %s currently.", si.getType()));
    }

    private static DataType avro2SqlType(Schema avroSchema, Set<String> existingRecordNames) throws IncompatibleSchemaException {
        org.apache.pulsar.shade.org.apache.avro.LogicalType logicalType = avroSchema.getLogicalType();
        switch (avroSchema.getType()) {
            case INT: {
                if (logicalType instanceof LogicalTypes.Date) {
                    return DataTypes.DATE();
                }
                return DataTypes.INT();
            }
            case STRING: 
            case ENUM: {
                return DataTypes.STRING();
            }
            case BOOLEAN: {
                return DataTypes.BOOLEAN();
            }
            case BYTES: 
            case FIXED: {
                if (logicalType instanceof LogicalTypes.Decimal) {
                    LogicalTypes.Decimal d = (LogicalTypes.Decimal)logicalType;
                    return DataTypes.DECIMAL((int)d.getPrecision(), (int)d.getScale());
                }
                return DataTypes.BYTES();
            }
            case DOUBLE: {
                return DataTypes.DOUBLE();
            }
            case FLOAT: {
                return DataTypes.FLOAT();
            }
            case LONG: {
                if (logicalType instanceof LogicalTypes.TimestampMillis || logicalType instanceof LogicalTypes.TimestampMicros) {
                    return DataTypes.TIMESTAMP((int)3);
                }
                return DataTypes.BIGINT();
            }
            case RECORD: {
                if (existingRecordNames.contains(avroSchema.getFullName())) {
                    throw new IncompatibleSchemaException(String.format("Found recursive reference in Avro schema, which can not be processed by Flink: %s", avroSchema.toString(true)), null);
                }
                ImmutableSet newRecordName = ImmutableSet.builder().addAll(existingRecordNames).add((Object)avroSchema.getFullName()).build();
                ArrayList<DataTypes.Field> fields = new ArrayList<DataTypes.Field>();
                for (Schema.Field f2 : avroSchema.getFields()) {
                    DataType fieldType = SimpleSchemaTranslator.avro2SqlType(f2.schema(), (Set<String>)newRecordName);
                    fields.add(DataTypes.FIELD((String)f2.name(), (DataType)fieldType));
                }
                return DataTypes.ROW((DataTypes.Field[])fields.toArray(new DataTypes.Field[0]));
            }
            case ARRAY: {
                DataType elementType = SimpleSchemaTranslator.avro2SqlType(avroSchema.getElementType(), existingRecordNames);
                return DataTypes.ARRAY((DataType)elementType);
            }
            case MAP: {
                DataType valueType = SimpleSchemaTranslator.avro2SqlType(avroSchema.getValueType(), existingRecordNames);
                return DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)valueType);
            }
            case UNION: {
                if (avroSchema.getTypes().stream().anyMatch(f -> f.getType() == Schema.Type.NULL)) {
                    List remainingUnionTypes = avroSchema.getTypes().stream().filter(f -> f.getType() != Schema.Type.NULL).collect(Collectors.toList());
                    if (remainingUnionTypes.size() == 1) {
                        return (DataType)SimpleSchemaTranslator.avro2SqlType((Schema)remainingUnionTypes.get(0), existingRecordNames).nullable();
                    }
                    return (DataType)SimpleSchemaTranslator.avro2SqlType(Schema.createUnion(remainingUnionTypes), existingRecordNames).nullable();
                }
                List types = avroSchema.getTypes().stream().map(Schema::getType).collect(Collectors.toList());
                if (types.size() == 1) {
                    return SimpleSchemaTranslator.avro2SqlType((Schema)avroSchema.getTypes().get(0), existingRecordNames);
                }
                if (types.size() == 2 && types.contains(Schema.Type.INT) && types.contains(Schema.Type.LONG)) {
                    return DataTypes.BIGINT();
                }
                if (types.size() == 2 && types.contains(Schema.Type.FLOAT) && types.contains(Schema.Type.DOUBLE)) {
                    return DataTypes.DOUBLE();
                }
                ArrayList<DataTypes.Field> memberFields = new ArrayList<DataTypes.Field>();
                List schemas = avroSchema.getTypes();
                for (int i = 0; i < schemas.size(); ++i) {
                    DataType memberType = SimpleSchemaTranslator.avro2SqlType((Schema)schemas.get(i), existingRecordNames);
                    memberFields.add(DataTypes.FIELD((String)("member" + i), (DataType)memberType));
                }
                return DataTypes.ROW((DataTypes.Field[])memberFields.toArray(new DataTypes.Field[0]));
            }
        }
        throw new IncompatibleSchemaException(String.format("Unsupported type %s", avroSchema.toString(true)), null);
    }

    public boolean isUseExtendField() {
        return this.useExtendField;
    }

    static {
        for (int i = 0; i < minBytesForPrecision.length; ++i) {
            SimpleSchemaTranslator.minBytesForPrecision[i] = SimpleSchemaTranslator.computeMinBytesForPrecision(i);
        }
        METADATA_FIELDS = ImmutableList.of((Object)DataTypes.FIELD((String)"__key", (DataType)DataTypes.BYTES()), (Object)DataTypes.FIELD((String)"__topic", (DataType)DataTypes.STRING()), (Object)DataTypes.FIELD((String)"__messageId", (DataType)DataTypes.BYTES()), (Object)DataTypes.FIELD((String)"__publishTime", (DataType)DataTypes.TIMESTAMP((int)3)), (Object)DataTypes.FIELD((String)"__eventTime", (DataType)DataTypes.TIMESTAMP((int)3)));
    }
}

