/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.io.Serializable;
import org.apache.flink.streaming.connectors.pulsar.internal.IncompatibleSchemaException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.BooleanSchema;
import org.apache.pulsar.client.impl.schema.ByteSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.DoubleSchema;
import org.apache.pulsar.client.impl.schema.FloatSchema;
import org.apache.pulsar.client.impl.schema.IntSchema;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.client.impl.schema.ShortSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public abstract class SchemaTranslator
implements Serializable {
    public abstract SchemaInfo tableSchemaToPulsarSchema(TableSchema var1) throws IncompatibleSchemaException;

    public abstract TableSchema pulsarSchemaToTableSchema(SchemaInfo var1) throws IncompatibleSchemaException;

    public abstract FieldsDataType pulsarSchemaToFieldsDataType(SchemaInfo var1) throws IncompatibleSchemaException;

    public abstract DataType schemaInfo2SqlType(SchemaInfo var1) throws IncompatibleSchemaException;

    public static Schema atomicType2PulsarSchema(DataType flinkType) throws IncompatibleSchemaException {
        LogicalTypeRoot type = flinkType.getLogicalType().getTypeRoot();
        switch (type) {
            case BOOLEAN: {
                return BooleanSchema.of();
            }
            case VARBINARY: {
                return BytesSchema.of();
            }
            case DATE: {
                SchemaInfo localDate = SchemaInfo.builder().name("LocalDate").type(SchemaType.valueOf((String)"LOCAL_DATE")).schema(new byte[0]).build();
                return Schema.getSchema((SchemaInfo)localDate);
            }
            case VARCHAR: {
                return Schema.STRING;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                SchemaInfo localDateTime = SchemaInfo.builder().name("LocalDateTime").type(SchemaType.valueOf((String)"LOCAL_DATE_TIME")).schema(new byte[0]).build();
                return Schema.getSchema((SchemaInfo)localDateTime);
            }
            case TINYINT: {
                return ByteSchema.of();
            }
            case DOUBLE: {
                return DoubleSchema.of();
            }
            case FLOAT: {
                return FloatSchema.of();
            }
            case INTEGER: {
                return IntSchema.of();
            }
            case BIGINT: {
                return LongSchema.of();
            }
            case SMALLINT: {
                return ShortSchema.of();
            }
        }
        throw new IncompatibleSchemaException(String.format("%s is not supported by Pulsar yet", flinkType.toString()), null);
    }
}

