/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.streaming.connectors.pulsar.SerializableFunction;
import org.apache.flink.streaming.connectors.pulsar.config.RecordSchemaType;
import org.apache.flink.streaming.connectors.pulsar.internal.IncompatibleSchemaException;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarContextAware;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarSerializationSchema;
import org.apache.flink.streaming.connectors.pulsar.internal.SchemaTranslator;
import org.apache.flink.streaming.connectors.pulsar.internal.SchemaUtils;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;

public class PulsarSerializationSchemaWrapper<T>
implements PulsarSerializationSchema<T>,
PulsarContextAware<T> {
    private final String topic;
    private final SerializationSchema<T> serializationSchema;
    private final RecordSchemaType recordSchemaType;
    private final Schema<?> schema;
    private final Class<?> clazz;
    private final DataType dataType;
    private final SchemaMode schemaMode;
    private final SerializableFunction<T, String> topicExtractor;
    private final SerializableFunction<T, byte[]> keyExtractor;
    private int parallelInstanceId;
    private int numParallelInstances;

    private PulsarSerializationSchemaWrapper(String topic, SerializationSchema<T> serializationSchema, RecordSchemaType recordSchemaType, Class<?> clazz, Schema<?> schema, DataType dataType, SchemaMode schemaMode, SerializableFunction<T, String> topicExtractor, SerializableFunction<T, byte[]> keyExtractor) {
        this.topic = topic;
        this.serializationSchema = serializationSchema;
        this.recordSchemaType = recordSchemaType;
        this.schema = schema;
        this.clazz = clazz;
        this.dataType = dataType;
        this.schemaMode = schemaMode;
        this.topicExtractor = topicExtractor;
        this.keyExtractor = keyExtractor;
    }

    @Override
    public void setParallelInstanceId(int parallelInstanceId) {
        this.parallelInstanceId = parallelInstanceId;
    }

    @Override
    public void setNumParallelInstances(int numParallelInstances) {
        this.numParallelInstances = numParallelInstances;
    }

    @Override
    public void setPartitions(int[] partitions) {
    }

    @Override
    public String getTargetTopic(T element) {
        if (this.topicExtractor == null) {
            return this.topic;
        }
        return (String)this.topicExtractor.apply(element);
    }

    @Override
    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.serializationSchema.open(context);
    }

    @Override
    public byte[] serialize(T element) {
        return this.serializationSchema.serialize(element);
    }

    @Override
    public void serialize(T element, TypedMessageBuilder<byte[]> messageBuilder) {
        messageBuilder.value((Object)this.serializationSchema.serialize(element));
    }

    @Override
    public Schema<?> getPulsarSchema() {
        try {
            switch (this.schemaMode) {
                case SPECIAL: {
                    return this.schema;
                }
                case ATOMIC: {
                    return SchemaTranslator.atomicType2PulsarSchema(this.dataType);
                }
                case POJO: {
                    return SchemaUtils.buildSchemaForRecordClazz(this.clazz, this.recordSchemaType);
                }
                case ROW: {
                    return SchemaUtils.buildRowSchema(this.dataType, this.recordSchemaType);
                }
            }
        }
        catch (IncompatibleSchemaException e) {
            throw new IllegalStateException(e);
        }
        if (this.schema != null) {
            return this.schema;
        }
        try {
            if (this.dataType instanceof AtomicDataType) {
                return SchemaTranslator.atomicType2PulsarSchema(this.dataType);
            }
            Preconditions.checkNotNull(this.clazz, (String)"for non-atomic type, you must set clazz");
            Preconditions.checkNotNull(this.clazz, (String)"for non-atomic type, you must set recordSchemaType");
            return SchemaUtils.buildSchemaForRecordClazz(this.clazz, this.recordSchemaType);
        }
        catch (IncompatibleSchemaException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getKey(T element) {
        return this.keyExtractor == null ? null : (byte[])this.keyExtractor.apply(element);
    }

    static enum SchemaMode {
        ATOMIC,
        POJO,
        SPECIAL,
        ROW;

    }

    @PublicEvolving
    public static class Builder<T> {
        private String topic;
        private final SerializationSchema<T> serializationSchema;
        private RecordSchemaType recordSchemaType;
        private Schema<?> schema;
        private Class<?> clazz;
        private DataType dataType;
        private SchemaMode mode;
        private SerializableFunction<T, String> topicExtractor;
        private SerializableFunction<T, byte[]> keyExtractor;

        public Builder(SerializationSchema<T> serializationSchema) {
            this.serializationSchema = serializationSchema;
        }

        public Builder<T> useSpecialMode(Schema<?> schema) {
            Preconditions.checkArgument((this.mode == null ? 1 : 0) != 0, (Object)"you can only set one schemaMode");
            this.mode = SchemaMode.SPECIAL;
            this.schema = schema;
            return this;
        }

        public Builder<T> useAtomicMode(DataType dataType) {
            Preconditions.checkArgument((this.mode == null ? 1 : 0) != 0, (Object)"you can only set one schemaMode");
            this.mode = SchemaMode.ATOMIC;
            Preconditions.checkArgument((boolean)(dataType instanceof AtomicDataType), (Object)"you must set an atomic dataType");
            this.dataType = dataType;
            return this;
        }

        public Builder<T> usePojoMode(Class<?> clazz, RecordSchemaType recordSchemaType) {
            Preconditions.checkArgument((this.mode == null ? 1 : 0) != 0, (Object)"you can only set one schemaMode");
            this.mode = SchemaMode.POJO;
            Preconditions.checkArgument((recordSchemaType != RecordSchemaType.ATOMIC ? 1 : 0) != 0, (Object)"cant ues RecordSchemaType.ATOMIC to build pojo type schema");
            this.clazz = clazz;
            this.recordSchemaType = recordSchemaType;
            return this;
        }

        public Builder<T> useRowMode(DataType dataType, RecordSchemaType recordSchemaType) {
            Preconditions.checkArgument((this.mode == null ? 1 : 0) != 0, (Object)"you can only set one schemaMode");
            this.mode = SchemaMode.ROW;
            this.dataType = dataType;
            this.recordSchemaType = recordSchemaType;
            return this;
        }

        public Builder<T> setKeyExtractor(SerializableFunction<T, byte[]> keyExtractor) {
            this.keyExtractor = keyExtractor;
            return this;
        }

        public Builder<T> setTopicExtractor(SerializableFunction<T, String> topicExtractor) {
            this.topicExtractor = topicExtractor;
            return this;
        }

        public Builder<T> setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public PulsarSerializationSchemaWrapper<T> build() {
            return new PulsarSerializationSchemaWrapper(this.topic, this.serializationSchema, this.recordSchemaType, this.clazz, this.schema, this.dataType, this.mode, this.topicExtractor, this.keyExtractor);
        }
    }
}

