/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.io.IOException;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.impl.schema.AvroSchema;

public class AvroDeser<T>
implements DeserializationSchema<T> {
    private final Class<T> recordClazz;
    private transient AvroSchema<T> pulsarSchema;

    private AvroDeser(Class<T> recordClazz) {
        Preconditions.checkNotNull(recordClazz, (String)"Avro record class must not be null");
        this.recordClazz = recordClazz;
    }

    public static <T> AvroDeser<T> of(Class<T> recordClazz) {
        return new AvroDeser<T>(recordClazz);
    }

    public T deserialize(byte[] message) throws IOException {
        this.checkPulsarAvroSchemaInitialized();
        return (T)this.pulsarSchema.decode(message);
    }

    public boolean isEndOfStream(T nextElement) {
        return false;
    }

    public TypeInformation<T> getProducedType() {
        return TypeInformation.of(this.recordClazz);
    }

    private void checkPulsarAvroSchemaInitialized() {
        if (this.pulsarSchema != null) {
            return;
        }
        this.pulsarSchema = AvroSchema.of(this.recordClazz);
    }
}

