/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar;

import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.streaming.connectors.pulsar.PulsarTableSink;
import org.apache.flink.streaming.connectors.pulsar.SerializableFunction;
import org.apache.flink.streaming.connectors.pulsar.config.RecordSchemaType;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarContextAware;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarSerializationSchema;
import org.apache.flink.streaming.connectors.pulsar.internal.SchemaUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;

public class PulsarRowSerializationSchema
implements PulsarSerializationSchema<Row>,
PulsarContextAware<Row> {
    private static final long serialVersionUID = 1L;
    private final String topic;
    private final SerializationSchema<Row> valueSerialization;
    private final boolean hasMetadata;
    private final int[] metadataPositions;
    private final int[] physicalPos;
    private final RecordSchemaType recordSchemaType;
    private final DataType dataType;
    private final SerializableFunction<Row, String> topicExtractor;
    private int[] partitions;
    private int parallelInstanceId;
    private int numParallelInstances;

    PulsarRowSerializationSchema(String topic, SerializableFunction<Row, String> topicExtractor, SerializationSchema<Row> valueSerialization, boolean hasMetadata, int[] metadataPositions, int[] physicalPos, RecordSchemaType recordSchemaType, DataType dataType) {
        this.topic = topic;
        this.topicExtractor = topicExtractor;
        this.valueSerialization = valueSerialization;
        this.hasMetadata = hasMetadata;
        this.metadataPositions = metadataPositions;
        this.physicalPos = physicalPos;
        this.recordSchemaType = recordSchemaType;
        this.dataType = dataType;
    }

    PulsarRowSerializationSchema(String topic, SerializationSchema<Row> valueSerialization, boolean hasMetadata, int[] metadataPositions, int[] physicalPos, RecordSchemaType recordSchemaType, DataType dataType) {
        this(topic, null, valueSerialization, hasMetadata, metadataPositions, physicalPos, recordSchemaType, dataType);
    }

    @Override
    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.valueSerialization.open(context);
    }

    @Override
    public byte[] serialize(Row element) {
        throw new IllegalStateException("In Row mode we use serialize method with 2 args");
    }

    @Override
    public void serialize(Row consumedRow, TypedMessageBuilder<byte[]> messageBuilder) {
        Row physicalRow;
        if (!this.hasMetadata) {
            physicalRow = consumedRow;
        } else {
            int physicalArity = this.physicalPos.length;
            Row row = new Row(consumedRow.getKind(), physicalArity);
            for (int i = 0; i < physicalArity; ++i) {
                row.setField(i, consumedRow.getField(this.physicalPos[i]));
            }
            physicalRow = row;
        }
        byte[] valueSerialized = this.valueSerialization.serialize((Object)physicalRow);
        messageBuilder.value((Object)valueSerialized);
    }

    @Override
    public Schema<?> getPulsarSchema() {
        return SchemaUtils.buildRowSchema(this.dataType, this.recordSchemaType);
    }

    @Override
    public void setParallelInstanceId(int parallelInstanceId) {
        this.parallelInstanceId = parallelInstanceId;
    }

    @Override
    public void setNumParallelInstances(int numParallelInstances) {
        this.numParallelInstances = numParallelInstances;
    }

    @Override
    public void setPartitions(int[] partitions) {
        this.partitions = partitions;
    }

    @Override
    public String getTargetTopic(Row element) {
        if (this.topicExtractor == null) {
            return this.topic;
        }
        return (String)this.topicExtractor.apply(element);
    }

    @Override
    public byte[] getKey(Row element) {
        return null;
    }

    private <T> T readMetadata(Row consumedRow, PulsarTableSink.WritableMetadata metadata) {
        int pos = this.metadataPositions[metadata.ordinal()];
        if (pos < 0) {
            return null;
        }
        return (T)metadata.converter.read(consumedRow, pos);
    }

    static interface WritableRowMetadataConverter {
        public Object read(Row var1, int var2);
    }
}

