/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar;

import java.util.Optional;
import java.util.Properties;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.connectors.pulsar.FlinkPulsarSinkBase;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarClientUtils;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarContextAware;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarSerializationSchema;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializableObject;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;

public class FlinkPulsarSink<T>
extends FlinkPulsarSinkBase<T> {
    private final PulsarSerializationSchema<T> serializationSchema;

    public FlinkPulsarSink(String adminUrl, Optional<String> defaultTopicName, ClientConfigurationData clientConf, Properties properties, PulsarSerializationSchema serializationSchema) {
        super(adminUrl, defaultTopicName, clientConf, properties, serializationSchema);
        this.serializationSchema = serializationSchema;
    }

    public FlinkPulsarSink(String serviceUrl, String adminUrl, Optional<String> defaultTopicName, Properties properties, PulsarSerializationSchema<T> serializationSchema) {
        this(adminUrl, defaultTopicName, PulsarClientUtils.newClientConf((String)Preconditions.checkNotNull((Object)serviceUrl), properties), properties, (PulsarSerializationSchema)serializationSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(T value, SinkFunction.Context context) throws Exception {
        this.checkErroneous();
        this.initializeSendCallback();
        String targetTopic = null;
        byte[] key = null;
        if (this.serializationSchema instanceof PulsarContextAware) {
            PulsarContextAware contextAwareSchema = (PulsarContextAware)((Object)this.serializationSchema);
            targetTopic = contextAwareSchema.getTargetTopic(value);
            key = contextAwareSchema.getKey(value);
        }
        if (targetTopic == null) {
            targetTopic = this.defaultTopic;
        }
        TypedMessageBuilder mb = this.getProducer(targetTopic).newMessage();
        this.serializationSchema.serialize(value, (TypedMessageBuilder<byte[]>)mb);
        if (key != null) {
            mb.keyBytes(key);
        }
        if (this.flushOnCheckpoint) {
            SerializableObject serializableObject = this.pendingRecordsLock;
            synchronized (serializableObject) {
                ++this.pendingRecords;
            }
        }
        mb.sendAsync().whenComplete(this.sendCallback);
    }
}

