/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.atomic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.formats.atomic.AtomicRowDeserializationSchema;
import org.apache.flink.formats.atomic.AtomicRowSerializationSchema;
import org.apache.flink.formats.json.JsonRowSchemaConverter;
import org.apache.flink.table.descriptors.AtomicValidator;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.DeserializationSchemaFactory;
import org.apache.flink.table.factories.SerializationSchemaFactory;
import org.apache.flink.table.factories.TableFormatFactoryBase;
import org.apache.flink.types.Row;

public class AtomicRowFormatFactory
extends TableFormatFactoryBase<Row>
implements SerializationSchemaFactory<Row>,
DeserializationSchemaFactory<Row> {
    public AtomicRowFormatFactory() {
        super("atomic", 1, true);
    }

    protected List<String> supportedFormatProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("format.atomic-schema");
        properties.add("format.classname");
        return properties;
    }

    public DeserializationSchema<Row> createDeserializationSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = AtomicRowFormatFactory.getValidatedProperties(properties);
        String className = descriptorProperties.getString("format.classname");
        boolean useExtendFields = descriptorProperties.getOptionalBoolean("connector.use-extend-field").orElse(false);
        AtomicRowDeserializationSchema.Builder builder = new AtomicRowDeserializationSchema.Builder(className);
        builder.useExtendFields(useExtendFields);
        return builder.build();
    }

    public SerializationSchema<Row> createSerializationSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = AtomicRowFormatFactory.getValidatedProperties(properties);
        String className = descriptorProperties.getString("format.classname");
        boolean useExtendFields = descriptorProperties.getOptionalBoolean("connector.use-extend-field").orElse(false);
        AtomicRowSerializationSchema.Builder builder = new AtomicRowSerializationSchema.Builder(className);
        builder.useExtendFields(useExtendFields);
        return builder.build();
    }

    private TypeInformation<Row> createTypeInformation(DescriptorProperties descriptorProperties) {
        if (descriptorProperties.containsKey("format.schema")) {
            return (RowTypeInfo)descriptorProperties.getType("format.schema");
        }
        if (descriptorProperties.containsKey("format.json-schema")) {
            return JsonRowSchemaConverter.convert((String)descriptorProperties.getString("format.json-schema"));
        }
        return AtomicRowFormatFactory.deriveSchema((Map)descriptorProperties.asMap()).toRowType();
    }

    private static DescriptorProperties getValidatedProperties(Map<String, String> propertiesMap) {
        DescriptorProperties descriptorProperties = new DescriptorProperties();
        descriptorProperties.putProperties(propertiesMap);
        new AtomicValidator().validate(descriptorProperties);
        return descriptorProperties;
    }
}

