/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarDeserializationSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.pulsar.client.api.Message;

public class DynamicPulsarDeserializationSchema
implements PulsarDeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final DeserializationSchema<RowData> valueDeserialization;
    private final boolean hasMetadata;
    private final ReadableRowDataMetadataConverter[] metadataConverters;
    private final TypeInformation<RowData> producedTypeInfo;

    DynamicPulsarDeserializationSchema(DeserializationSchema<RowData> valueDeserialization, boolean hasMetadata, ReadableRowDataMetadataConverter[] metadataConverters, TypeInformation<RowData> producedTypeInfo) {
        this.hasMetadata = hasMetadata;
        this.valueDeserialization = valueDeserialization;
        this.producedTypeInfo = producedTypeInfo;
        this.metadataConverters = metadataConverters;
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.valueDeserialization.open(context);
    }

    @Override
    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    @Override
    public RowData deserialize(Message record) throws IOException {
        int i;
        if (!this.hasMetadata) {
            return (RowData)this.valueDeserialization.deserialize(record.getData());
        }
        RowData physicalRow = (RowData)this.valueDeserialization.deserialize(record.getData());
        GenericRowData genericPhysicalRow = (GenericRowData)physicalRow;
        int physicalArity = physicalRow.getArity();
        int metadataArity = this.metadataConverters.length;
        GenericRowData producedRow = new GenericRowData(physicalRow.getRowKind(), physicalArity + metadataArity);
        for (i = 0; i < physicalArity; ++i) {
            producedRow.setField(i, genericPhysicalRow.getField(i));
        }
        for (i = 0; i < metadataArity; ++i) {
            producedRow.setField(i + physicalArity, this.metadataConverters[i].read(record));
        }
        return producedRow;
    }

    public TypeInformation<RowData> getProducedType() {
        if (this.hasMetadata) {
            return this.producedTypeInfo;
        }
        return this.valueDeserialization.getProducedType();
    }

    static interface ReadableRowDataMetadataConverter
    extends Serializable {
        public Object read(Message var1);
    }
}

