/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.util;

import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class PulsarAdminUtils {
    public static PulsarAdmin newAdminFromConf(String adminUrl, ClientConfigurationData clientConfigurationData) throws PulsarClientException {
        ClientConfigurationData adminConf = clientConfigurationData.clone();
        adminConf.setServiceUrl(adminUrl);
        PulsarAdminUtils.setAuth(adminConf);
        return new PulsarAdmin(adminUrl, adminConf);
    }

    private static void setAuth(ClientConfigurationData conf) throws PulsarClientException {
        if (!StringUtils.isBlank((CharSequence)conf.getAuthPluginClassName()) && !StringUtils.isBlank((CharSequence)conf.getAuthParams())) {
            conf.setAuthentication(AuthenticationFactory.create((String)conf.getAuthPluginClassName(), (String)conf.getAuthParams()));
        }
    }
}

