/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.util.Collector;
import org.apache.pulsar.client.api.Message;

public interface MessageDeserializer<T>
extends Serializable,
ResultTypeQueryable<T> {
    public void deserialize(Message<?> var1, Collector<T> var2) throws IOException;

    public boolean isEndOfStream(T var1);

    public static <V> MessageDeserializer<V> valueOnly(final DeserializationSchema<V> valueDeserializer) {
        return new MessageDeserializer<V>(){

            @Override
            public void deserialize(Message<?> message, Collector<V> collector) throws IOException {
                valueDeserializer.deserialize(message.getData(), collector);
            }

            @Override
            public boolean isEndOfStream(V nextElement) {
                return valueDeserializer.isEndOfStream(nextElement);
            }

            public TypeInformation<V> getProducedType() {
                return valueDeserializer.getProducedType();
            }
        };
    }
}

