/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.serialization;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.util.serialization.FlinkSchema;
import org.apache.flink.streaming.util.serialization.PulsarContextAware;
import org.apache.flink.streaming.util.serialization.PulsarDeserializationSchemaBuilder;
import org.apache.flink.util.Collector;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;

@PublicEvolving
public interface PulsarDeserializationSchema<T>
extends PulsarContextAware<T>,
Serializable {
    @Deprecated
    public static <V> PulsarDeserializationSchemaBuilder<V> builder() {
        return new PulsarDeserializationSchemaBuilder();
    }

    public static <V> PulsarDeserializationSchema<V> valueOnly(final DeserializationSchema<V> valueDeserializer) {
        return new PulsarDeserializationSchema<V>(){

            @Override
            public Schema<V> getSchema() {
                return new FlinkSchema(Schema.BYTES.getSchemaInfo(), null, valueDeserializer);
            }

            @Override
            public V deserialize(Message<V> message) throws IOException {
                return message.getValue();
            }

            @Override
            public boolean isEndOfStream(V nextElement) {
                return valueDeserializer.isEndOfStream(nextElement);
            }

            public TypeInformation<V> getProducedType() {
                return valueDeserializer.getProducedType();
            }
        };
    }

    default public void open(DeserializationSchema.InitializationContext context) throws Exception {
    }

    public boolean isEndOfStream(T var1);

    public T deserialize(Message<T> var1) throws IOException;

    default public void deserialize(Message<T> message, Collector<T> out) throws IOException {
        out.collect(this.deserialize(message));
    }
}

