/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.split;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.connector.pulsar.source.AbstractPartition;
import org.apache.flink.connector.pulsar.source.StartOffsetInitializer;
import org.apache.flink.connector.pulsar.source.StopCondition;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.MessageId;

@Internal
public class PulsarPartitionSplit
implements SourceSplit,
Serializable,
Cloneable {
    private final AbstractPartition partition;
    private final StartOffsetInitializer startOffsetInitializer;
    private final StopCondition stopCondition;
    @Nullable
    private MessageId lastConsumedId;

    public PulsarPartitionSplit(AbstractPartition partition, StartOffsetInitializer startOffsetInitializer, StopCondition stopCondition) {
        this.partition = (AbstractPartition)Preconditions.checkNotNull((Object)partition);
        this.startOffsetInitializer = (StartOffsetInitializer)Preconditions.checkNotNull((Object)startOffsetInitializer);
        this.stopCondition = (StopCondition)Preconditions.checkNotNull((Object)stopCondition);
    }

    public String getTopic() {
        return this.partition.getTopic();
    }

    public AbstractPartition getPartition() {
        return this.partition;
    }

    public StartOffsetInitializer getStartOffsetInitializer() {
        return this.startOffsetInitializer;
    }

    public StopCondition getStopCondition() {
        return this.stopCondition;
    }

    @Nullable
    public MessageId getLastConsumedId() {
        return this.lastConsumedId;
    }

    public void setLastConsumedId(MessageId lastConsumedId) {
        this.lastConsumedId = lastConsumedId;
    }

    public String splitId() {
        return this.partition.toString();
    }

    public String toString() {
        return String.format("[Partition: %s, lastConsumedId: %d]", this.partition, this.lastConsumedId);
    }

    public PulsarPartitionSplit clone() {
        try {
            return (PulsarPartitionSplit)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

