/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.connector.pulsar.source.enumerator.PulsarSourceEnumeratorState;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplitSerializer;
import org.apache.flink.connector.pulsar.source.util.SerdeUtils;
import org.apache.flink.core.io.SimpleVersionedSerializer;

public class PulsarSourceEnumeratorStateSerializer
implements SimpleVersionedSerializer<PulsarSourceEnumeratorState> {
    private static final int CURRENT_VERSION = 0;

    public int getVersion() {
        return 0;
    }

    public byte[] serialize(PulsarSourceEnumeratorState enumState) throws IOException {
        return SerdeUtils.serializeSplitAssignments(enumState.getCurrentAssignment(), new PulsarPartitionSplitSerializer());
    }

    public PulsarSourceEnumeratorState deserialize(int version, byte[] serialized) throws IOException {
        if (version == 0) {
            Map<Integer, List<PulsarPartitionSplit>> currentPartitionAssignment = SerdeUtils.deserializeSplitAssignments(serialized, new PulsarPartitionSplitSerializer(), ArrayList::new);
            return new PulsarSourceEnumeratorState(currentPartitionAssignment);
        }
        throw new IOException(String.format("The bytes are serialized with version %d, while this deserializer only supports version up to %d", version, 0));
    }
}

