/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.serialization;

import java.io.IOException;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.util.Collector;

public class ThreadSafeDeserializationSchema<T>
implements DeserializationSchema<T> {
    private DeserializationSchema<T> deserializationSchema;

    private ThreadSafeDeserializationSchema(DeserializationSchema<T> deserializationSchema) {
        this.deserializationSchema = deserializationSchema;
    }

    public static ThreadSafeDeserializationSchema of(DeserializationSchema deserializationSchema) {
        return deserializationSchema != null ? new ThreadSafeDeserializationSchema(deserializationSchema) : null;
    }

    public synchronized void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.deserializationSchema.open(context);
    }

    public synchronized T deserialize(byte[] bytes) throws IOException {
        return (T)this.deserializationSchema.deserialize(bytes);
    }

    public synchronized void deserialize(byte[] message, Collector<T> out) throws IOException {
        this.deserializationSchema.deserialize(message, out);
    }

    public synchronized boolean isEndOfStream(T object) {
        return this.deserializationSchema.isEndOfStream(object);
    }

    public synchronized TypeInformation getProducedType() {
        return this.deserializationSchema.getProducedType();
    }
}

