/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.pulsar.source.AbstractPartition;
import org.apache.flink.connector.pulsar.source.offset.ExternalSubscriptionStartOffsetInitializer;
import org.apache.flink.connector.pulsar.source.offset.RollbackStartOffsetInitializer;
import org.apache.flink.connector.pulsar.source.offset.SpecifiedStartOffsetInitializer;
import org.apache.flink.connector.pulsar.source.offset.TimestampStartOffsetInitializer;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;

@PublicEvolving
public interface StartOffsetInitializer
extends Serializable {
    default public void initializeBeforeCreation(AbstractPartition partition, CreationConfiguration configuration) {
    }

    default public void initializeAfterCreation(AbstractPartition partition, Consumer<?> consumer) throws PulsarClientException {
    }

    default public Optional<String> verifyOffset(AbstractPartition partition, Supplier<Optional<MessageId>> lastMessageIdFetcher, Supplier<Optional<Message<byte[]>>> firstMessageFetcher) {
        return Optional.empty();
    }

    public static StartOffsetInitializer committedOffsets(String subscriptionName) {
        return StartOffsetInitializer.committedOffsets(subscriptionName, MessageId.earliest);
    }

    public static StartOffsetInitializer committedOffsets(String subscriptionName, MessageId defaultOffset) {
        return new ExternalSubscriptionStartOffsetInitializer(subscriptionName, defaultOffset);
    }

    public static StartOffsetInitializer timestamps(long timestamp) {
        return new TimestampStartOffsetInitializer(timestamp);
    }

    public static StartOffsetInitializer rollback(long rollbackDuration, TimeUnit timeUnit) {
        return new RollbackStartOffsetInitializer(timeUnit.toSeconds(rollbackDuration));
    }

    public static StartOffsetInitializer earliest() {
        return StartOffsetInitializer.earliest(true);
    }

    public static StartOffsetInitializer earliest(boolean inclusive) {
        return new SpecifiedStartOffsetInitializer(Collections.emptyMap(), MessageId.earliest, inclusive);
    }

    public static StartOffsetInitializer latest() {
        return StartOffsetInitializer.latest(true);
    }

    public static StartOffsetInitializer latest(boolean inclusive) {
        return new SpecifiedStartOffsetInitializer(Collections.emptyMap(), MessageId.latest, inclusive);
    }

    public static StartOffsetInitializer offset(MessageId offset, boolean inclusive) {
        return StartOffsetInitializer.offsets(Collections.emptyMap(), offset, inclusive);
    }

    public static StartOffsetInitializer offsets(Map<AbstractPartition, MessageId> offsets) {
        return StartOffsetInitializer.offsets(offsets, MessageId.earliest, true);
    }

    public static StartOffsetInitializer offsets(Map<AbstractPartition, MessageId> offsets, MessageId defaultOffset, boolean inclusive) {
        return new SpecifiedStartOffsetInitializer(offsets, defaultOffset, inclusive);
    }

    public static class CreationConfiguration {
        private final ConsumerConfigurationData<byte[]> consumerConfigurationData;
        @Nullable
        private MessageId initialMessageId;
        private long rollbackInS = 0L;

        public CreationConfiguration(ConsumerConfigurationData<byte[]> consumerConfigurationData) {
            this.consumerConfigurationData = consumerConfigurationData;
        }

        public ConsumerConfigurationData<byte[]> getConsumerConfigurationData() {
            return this.consumerConfigurationData;
        }

        @Nullable
        public MessageId getInitialMessageId() {
            return this.initialMessageId;
        }

        public void setInitialMessageId(@Nullable MessageId initialMessageId) {
            this.initialMessageId = initialMessageId;
        }

        public long getRollbackInS() {
            return this.rollbackInS;
        }

        public void setRollbackInS(long rollbackInS) {
            this.rollbackInS = rollbackInS;
        }
    }
}

