/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.connectors.pulsar.internal.IncompatibleSchemaException;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarMetadataReader;
import org.apache.flink.streaming.connectors.pulsar.internal.SchemaTranslator;
import org.apache.flink.streaming.connectors.pulsar.internal.SchemaUtils;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.types.DataType;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class PulsarCatalogSupport {
    private static final String COMMENT = "table.comment";
    private static final String IS_CATALOG_TOPIC = "is.catalog.topic";
    private PulsarMetadataReader pulsarMetadataReader;
    private SchemaTranslator schemaTranslator;

    public PulsarCatalogSupport(String adminUrl, ClientConfigurationData clientConfigurationData, String subscriptionName, Map<String, String> caseInsensitiveParams, int indexOfThisSubtask, int numParallelSubtasks, SchemaTranslator schemaTranslator) throws PulsarClientException {
        this.pulsarMetadataReader = new PulsarMetadataReader(adminUrl, clientConfigurationData, subscriptionName, caseInsensitiveParams, indexOfThisSubtask, numParallelSubtasks);
        this.schemaTranslator = schemaTranslator;
    }

    public List<String> listNamespaces() throws PulsarAdminException {
        return this.pulsarMetadataReader.listNamespaces();
    }

    public boolean namespaceExists(String databaseName) throws PulsarAdminException {
        return this.pulsarMetadataReader.namespaceExists(databaseName);
    }

    public void createNamespace(String name) throws PulsarAdminException {
        this.pulsarMetadataReader.createNamespace(name);
    }

    public List<String> getTopics(String databaseName) throws PulsarAdminException {
        return this.pulsarMetadataReader.getTopics(databaseName);
    }

    public CatalogTableImpl getTableSchema(ObjectPath tablePath, Map<String, String> properties) throws PulsarAdminException, IncompatibleSchemaException {
        String topicName = PulsarCatalogSupport.objectPath2TopicName(tablePath);
        SchemaInfo pulsarSchema = this.pulsarMetadataReader.getPulsarSchema(topicName);
        return this.schemaToCatalogTable(pulsarSchema, tablePath, properties);
    }

    public boolean topicExists(ObjectPath tablePath) throws PulsarAdminException {
        String topicName = PulsarCatalogSupport.objectPath2TopicName(tablePath);
        return this.pulsarMetadataReader.topicExists(topicName);
    }

    public void createTopic(ObjectPath tablePath, int defaultNumPartitions, CatalogBaseTable table) throws PulsarAdminException, IncompatibleSchemaException {
        String topicName = PulsarCatalogSupport.objectPath2TopicName(tablePath);
        this.pulsarMetadataReader.createTopic(topicName, defaultNumPartitions);
    }

    public void putSchema(ObjectPath tablePath, CatalogBaseTable table, String format) throws PulsarAdminException, IncompatibleSchemaException {
        String topicName = PulsarCatalogSupport.objectPath2TopicName(tablePath);
        TableSchema schema = table.getSchema();
        SchemaInfo schemaInfo = this.tableSchemaToPulsarSchema(format, schema, table.getOptions());
        if (!StringUtils.equals((CharSequence)format, (CharSequence)"atomic")) {
            ((SchemaInfoImpl)schemaInfo).setProperties(this.extractedProperties(table));
        }
        this.pulsarMetadataReader.putSchema(topicName, schemaInfo);
    }

    private Map<String, String> extractedProperties(CatalogBaseTable table) {
        DescriptorProperties tableSchemaProps = new DescriptorProperties(true);
        tableSchemaProps.putTableSchema("schema", table.getSchema());
        if (table instanceof CatalogTable) {
            tableSchemaProps.putPartitionKeys(((CatalogTable)table).getPartitionKeys());
        }
        Map<String, String> properties = new HashMap<String, String>(tableSchemaProps.asMap());
        properties = PulsarCatalogSupport.maskFlinkProperties(properties);
        if (table.getComment() == null) {
            properties.put(COMMENT, table.getComment());
        }
        properties.put(IS_CATALOG_TOPIC, "true");
        return properties;
    }

    public static Map<String, String> maskFlinkProperties(Map<String, String> properties) {
        return properties.entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).map(e -> new Tuple2((Object)("flink." + (String)e.getKey()), e.getValue())).collect(Collectors.toMap(t -> (String)t.f0, t -> (String)t.f1));
    }

    private static Map<String, String> retrieveFlinkProperties(Map<String, String> pulsarSchemaProperties) {
        return pulsarSchemaProperties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("flink.")).collect(Collectors.toMap(e -> ((String)e.getKey()).replace("flink.", ""), e -> (String)e.getValue()));
    }

    private SchemaInfo tableSchemaToPulsarSchema(String format, TableSchema schema, Map<String, String> options) throws IncompatibleSchemaException {
        DataType physicalRowDataType = schema.toPhysicalRowDataType();
        return SchemaUtils.tableSchemaToSchemaInfo(format, physicalRowDataType, options);
    }

    private CatalogTableImpl schemaToCatalogTable(SchemaInfo pulsarSchema, ObjectPath tablePath, Map<String, String> flinkProperties) throws IncompatibleSchemaException {
        boolean isCatalogTopic = Boolean.parseBoolean((String)pulsarSchema.getProperties().get(IS_CATALOG_TOPIC));
        if (isCatalogTopic) {
            Map properties = PulsarCatalogSupport.retrieveFlinkProperties(pulsarSchema.getProperties());
            DescriptorProperties tableSchemaProps = new DescriptorProperties(true);
            tableSchemaProps.putProperties(properties);
            TableSchema tableSchema = tableSchemaProps.getOptionalTableSchema("schema").orElseGet(() -> (TableSchema)tableSchemaProps.getOptionalTableSchema("generic.table.schema").orElseThrow(() -> new CatalogException("Failed to get table schema from properties for generic table " + tablePath)));
            List partitionKeys = tableSchemaProps.getPartitionKeys();
            properties = CatalogTableImpl.removeRedundant(properties, (TableSchema)tableSchema, (List)partitionKeys);
            properties.putAll(flinkProperties);
            properties.remove(IS_CATALOG_TOPIC);
            String comment = (String)properties.remove(COMMENT);
            return new CatalogTableImpl(tableSchema, partitionKeys, properties, comment);
        }
        TableSchema tableSchema = this.schemaTranslator.pulsarSchemaToTableSchema(pulsarSchema);
        return new CatalogTableImpl(tableSchema, flinkProperties, "");
    }

    public static String objectPath2TopicName(ObjectPath objectPath) {
        NamespaceName ns = NamespaceName.get((String)objectPath.getDatabaseName());
        String topic = objectPath.getObjectName();
        TopicName fullName = TopicName.get((String)TopicDomain.persistent.toString(), (NamespaceName)ns, (String)topic);
        return fullName.toString();
    }

    public void close() {
        if (this.pulsarMetadataReader != null) {
            this.pulsarMetadataReader.close();
        }
    }

    public void deleteTopic(ObjectPath tablePath) throws PulsarAdminException {
        String topicName = PulsarCatalogSupport.objectPath2TopicName(tablePath);
        this.pulsarMetadataReader.deleteTopic(topicName);
    }

    public void deleteNamespace(String name) throws PulsarAdminException {
        this.pulsarMetadataReader.deleteNamespace(name);
    }
}

