/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.io.IOException;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.impl.schema.JSONSchema;

public class JsonDeser<T>
implements DeserializationSchema<T> {
    private final Class<T> recordClazz;
    private transient JSONSchema<T> pulsarSchema;

    private JsonDeser(Class<T> recordClazz) {
        Preconditions.checkNotNull(recordClazz, (String)"JSON record class must not be null");
        this.recordClazz = recordClazz;
    }

    public static <T> JsonDeser<T> of(Class<T> recordClazz) {
        return new JsonDeser<T>(recordClazz);
    }

    public T deserialize(byte[] message) throws IOException {
        this.checkPulsarJsonSchemaInitialized();
        return (T)this.pulsarSchema.decode(message);
    }

    public boolean isEndOfStream(T nextElement) {
        return false;
    }

    public TypeInformation<T> getProducedType() {
        return TypeInformation.of(this.recordClazz);
    }

    private void checkPulsarJsonSchemaInitialized() {
        if (this.pulsarSchema != null) {
            return;
        }
        this.pulsarSchema = JSONSchema.of(this.recordClazz);
    }
}

