/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobufnative;

import com.google.protobuf.Descriptors;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.protobufnative.PulsarProtobufNativeRowDataDeserializationSchema;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarClientUtils;
import org.apache.flink.streaming.connectors.pulsar.table.PulsarTableOptions;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.StringUtils;
import org.apache.flink.util.function.SerializableSupplier;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeSchema;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarProtobufNativeFormatFactory
implements DeserializationFormatFactory {
    private static final Logger log = LoggerFactory.getLogger(PulsarProtobufNativeFormatFactory.class);
    public static final String IDENTIFIER = "pulsar-protobuf-native";

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        Configuration tableConf = Configuration.fromMap((Map)context.getCatalogTable().getOptions());
        String topic = this.extractTopicName(context);
        String adminUrl = (String)tableConf.get(PulsarTableOptions.ADMIN_URL);
        Optional stringMap = tableConf.getOptional(PulsarTableOptions.PROPERTIES);
        Properties properties = stringMap.map(map -> {
            Properties prop = new Properties();
            prop.putAll((Map<?, ?>)map);
            return prop;
        }).orElse(new Properties());
        final SerializableSupplier & Serializable loadDescriptor = (SerializableSupplier & Serializable)() -> {
            SchemaInfo schemaInfo = null;
            try {
                PulsarAdmin admin = PulsarClientUtils.newAdminFromConf(adminUrl, properties);
                schemaInfo = admin.schemas().getSchemaInfo(TopicName.get((String)topic).toString());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ((GenericProtobufNativeSchema)GenericProtobufNativeSchema.of((SchemaInfo)schemaInfo)).getProtobufNativeSchema();
        };
        return new DecodingFormat<DeserializationSchema<RowData>>(){

            public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType producedDataType) {
                RowType rowType = (RowType)producedDataType.getLogicalType();
                return new PulsarProtobufNativeRowDataDeserializationSchema((SerializableSupplier<Descriptors.Descriptor>)loadDescriptor, rowType);
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    private String extractTopicName(DynamicTableFactory.Context context) {
        this.validateTopic(context.getCatalogTable().getOptions());
        String topic = (String)context.getCatalogTable().getOptions().get(PulsarTableOptions.TOPIC.key());
        if (StringUtils.isNullOrWhitespaceOnly((String)topic)) {
            ObjectIdentifier table = context.getObjectIdentifier();
            topic = TopicName.get((String)(table.getDatabaseName() + "/" + table.getObjectName())).toString();
        }
        return topic;
    }

    private void validateTopic(Map<String, String> tableConf) {
        String topic = tableConf.get(PulsarTableOptions.TOPIC.key());
        if (!StringUtils.isNullOrWhitespaceOnly((String)topic) && tableConf.get(PulsarTableOptions.TOPIC_PATTERN.key()) != null) {
            throw new IllegalArgumentException("pulsar-protobuf-native  format only support single topic, not support topic pattern.");
        }
        if (null != topic && topic.contains(",")) {
            throw new IllegalArgumentException("pulsar-protobuf-native  format only support single topic, not support multiple topics.");
        }
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }
}

