/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.pulsar.factories;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.streaming.connectors.pulsar.table.PulsarTableOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.pulsar.PulsarCatalog;
import org.apache.flink.table.catalog.pulsar.factories.PulsarCatalogFactoryOptions;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class PulsarCatalogFactory
implements CatalogFactory {
    public String factoryIdentifier() {
        return "pulsar";
    }

    public Catalog createCatalog(CatalogFactory.Context context) {
        FactoryUtil.CatalogFactoryHelper helper = FactoryUtil.createCatalogFactoryHelper((CatalogFactory)this, (CatalogFactory.Context)context);
        helper.validate();
        return new PulsarCatalog((String)helper.getOptions().get(PulsarTableOptions.ADMIN_URL), context.getName(), context.getOptions(), (String)helper.getOptions().get(PulsarCatalogFactoryOptions.DEFAULT_DATABASE));
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(PulsarTableOptions.ADMIN_URL);
        options.add(PulsarTableOptions.SERVICE_URL);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet props = new HashSet();
        props.add(PulsarCatalogFactoryOptions.DEFAULT_DATABASE);
        props.add(FactoryUtil.PROPERTY_VERSION);
        props.add(PulsarTableOptions.SCAN_STARTUP_MODE);
        props.add(PulsarCatalogFactoryOptions.DEFAULT_PARTITIONS);
        props.add(PulsarTableOptions.KEY_FORMAT);
        props.add(PulsarTableOptions.KEY_FIELDS);
        props.add(PulsarTableOptions.KEY_FIELDS_PREFIX);
        props.add(PulsarTableOptions.VALUE_FORMAT);
        props.add(PulsarTableOptions.VALUE_FIELDS_INCLUDE);
        props.add(PulsarTableOptions.SINK_SEMANTIC);
        props.add(PulsarCatalogFactoryOptions.PULSAR_VERSION);
        props.add(FactoryUtil.FORMAT);
        props.add(PulsarTableOptions.PROPERTIES);
        return props;
    }
}

