/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.table;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.connectors.pulsar.table.PulsarDynamicTableSink;
import org.apache.flink.streaming.connectors.pulsar.table.PulsarDynamicTableSource;
import org.apache.flink.streaming.connectors.pulsar.table.PulsarTableOptions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.Format;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.apache.pulsar.common.naming.TopicName;

public class PulsarDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public static final String IDENTIFIER = "pulsar";
    private final boolean inCatalog;

    public PulsarDynamicTableFactory() {
        this.inCatalog = false;
    }

    public PulsarDynamicTableFactory(boolean inCatalog) {
        this.inCatalog = inCatalog;
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        if (this.inCatalog) {
            ObjectIdentifier table = context.getObjectIdentifier();
            String topic = TopicName.get((String)(table.getDatabaseName() + "/" + table.getObjectName())).toString();
            ((Configuration)tableOptions).set(PulsarTableOptions.TOPIC, Collections.singletonList(topic));
        }
        List topics = (List)tableOptions.get(PulsarTableOptions.TOPIC);
        String adminUrl = (String)tableOptions.get(PulsarTableOptions.ADMIN_URL);
        String serverUrl = (String)tableOptions.get(PulsarTableOptions.SERVICE_URL);
        Optional<EncodingFormat<SerializationSchema<RowData>>> keyEncodingFormat = PulsarDynamicTableFactory.getKeyEncodingFormat(helper);
        EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat = PulsarDynamicTableFactory.getValueEncodingFormat(helper);
        helper.validateExcept(new String[]{"properties.", "type", "table-default-partitions", "default-database"});
        PulsarTableOptions.validateTableSinkOptions(tableOptions);
        Properties properties = PulsarTableOptions.getPulsarProperties(context.getCatalogTable().toProperties());
        PulsarDynamicTableFactory.validatePKConstraints(context.getObjectIdentifier(), (CatalogTable)context.getCatalogTable(), valueEncodingFormat);
        DataType physicalDataType = context.getCatalogTable().getSchema().toPhysicalRowDataType();
        int[] keyProjection = PulsarTableOptions.createKeyFormatProjection(tableOptions, physicalDataType);
        int[] valueProjection = PulsarTableOptions.createValueFormatProjection(tableOptions, physicalDataType);
        String keyPrefix = tableOptions.getOptional(PulsarTableOptions.KEY_FIELDS_PREFIX).orElse(null);
        return this.createPulsarTableSink(tableOptions, topics, adminUrl, serverUrl, keyEncodingFormat, valueEncodingFormat, properties, physicalDataType, keyProjection, valueProjection, keyPrefix, context);
    }

    private PulsarDynamicTableSink createPulsarTableSink(ReadableConfig tableOptions, List<String> topics, String adminUrl, String serverUrl, Optional<EncodingFormat<SerializationSchema<RowData>>> keyEncodingFormat, EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat, Properties properties, DataType physicalDataType, int[] keyProjection, int[] valueProjection, String keyPrefix, DynamicTableFactory.Context context) {
        String formatType = tableOptions.getOptional(FactoryUtil.FORMAT).orElseGet(() -> (String)tableOptions.get(PulsarTableOptions.VALUE_FORMAT));
        Integer parallelism = tableOptions.getOptional(FactoryUtil.SINK_PARALLELISM).orElse(null);
        return new PulsarDynamicTableSink(serverUrl, adminUrl, topics.get(0), physicalDataType, properties, (EncodingFormat<SerializationSchema<RowData>>)((EncodingFormat)keyEncodingFormat.orElse(null)), valueEncodingFormat, keyProjection, valueProjection, keyPrefix, PulsarTableOptions.getSinkSemantic(tableOptions), formatType, false, parallelism, PulsarTableOptions.getMessageRouter(tableOptions, context.getClassLoader()).orElse(null));
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        if (this.inCatalog) {
            ObjectIdentifier table = context.getObjectIdentifier();
            String topic = TopicName.get((String)(table.getDatabaseName() + "/" + table.getObjectName())).toString();
            ((Configuration)tableOptions).set(PulsarTableOptions.TOPIC, Collections.singletonList(topic));
        }
        List topics = (List)tableOptions.get(PulsarTableOptions.TOPIC);
        String topicPattern = (String)tableOptions.get(PulsarTableOptions.TOPIC_PATTERN);
        String adminUrl = (String)tableOptions.get(PulsarTableOptions.ADMIN_URL);
        String serviceUrl = (String)tableOptions.get(PulsarTableOptions.SERVICE_URL);
        Optional<DecodingFormat<DeserializationSchema<RowData>>> keyDecodingFormat = PulsarDynamicTableFactory.getKeyDecodingFormat(helper);
        DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat = PulsarDynamicTableFactory.getValueDecodingFormat(helper);
        helper.validateExcept(new String[]{"properties.", "type", "table-default-partitions", "default-database"});
        PulsarTableOptions.validateTableSourceOptions(tableOptions);
        PulsarTableOptions.validateSinkMessageRouter(tableOptions);
        PulsarDynamicTableFactory.validatePKConstraints(context.getObjectIdentifier(), (CatalogTable)context.getCatalogTable(), valueDecodingFormat);
        Properties properties = PulsarTableOptions.getPulsarProperties(context.getCatalogTable().toProperties());
        PulsarTableOptions.StartupOptions startupOptions = PulsarTableOptions.getStartupOptions(tableOptions);
        DataType physicalDataType = context.getCatalogTable().getSchema().toPhysicalRowDataType();
        int[] keyProjection = PulsarTableOptions.createKeyFormatProjection(tableOptions, physicalDataType);
        int[] valueProjection = PulsarTableOptions.createValueFormatProjection(tableOptions, physicalDataType);
        String keyPrefix = tableOptions.getOptional(PulsarTableOptions.KEY_FIELDS_PREFIX).orElse(null);
        return this.createPulsarTableSource(physicalDataType, (DecodingFormat<DeserializationSchema<RowData>>)((DecodingFormat)keyDecodingFormat.orElse(null)), valueDecodingFormat, keyProjection, valueProjection, keyPrefix, topics, topicPattern, serviceUrl, adminUrl, properties, startupOptions);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(PulsarTableOptions.SERVICE_URL);
        options.add(PulsarTableOptions.ADMIN_URL);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(FactoryUtil.FORMAT);
        options.add(PulsarTableOptions.KEY_FORMAT);
        options.add(PulsarTableOptions.KEY_FIELDS);
        options.add(PulsarTableOptions.KEY_FIELDS_PREFIX);
        options.add(PulsarTableOptions.VALUE_FORMAT);
        options.add(PulsarTableOptions.VALUE_FIELDS_INCLUDE);
        options.add(PulsarTableOptions.TOPIC);
        options.add(PulsarTableOptions.TOPIC_PATTERN);
        options.add(PulsarTableOptions.SCAN_STARTUP_MODE);
        options.add(PulsarTableOptions.SCAN_STARTUP_SPECIFIC_OFFSETS);
        options.add(PulsarTableOptions.SCAN_STARTUP_SUB_NAME);
        options.add(PulsarTableOptions.SCAN_STARTUP_SUB_START_OFFSET);
        options.add(PulsarTableOptions.PARTITION_DISCOVERY_INTERVAL_MILLIS);
        options.add(PulsarTableOptions.SINK_SEMANTIC);
        options.add(PulsarTableOptions.SINK_MESSAGE_ROUTER);
        options.add(FactoryUtil.SINK_PARALLELISM);
        options.add(PulsarTableOptions.PROPERTIES);
        return options;
    }

    private static Optional<DecodingFormat<DeserializationSchema<RowData>>> getKeyDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        Optional keyDecodingFormat = helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, PulsarTableOptions.KEY_FORMAT);
        keyDecodingFormat.ifPresent(format -> {
            if (!format.getChangelogMode().containsOnly(RowKind.INSERT)) {
                throw new ValidationException(String.format("A key format should only deal with INSERT-only records. But %s has a changelog mode of %s.", helper.getOptions().get(PulsarTableOptions.KEY_FORMAT), format.getChangelogMode()));
            }
        });
        return keyDecodingFormat;
    }

    private static Optional<EncodingFormat<SerializationSchema<RowData>>> getKeyEncodingFormat(FactoryUtil.TableFactoryHelper helper) {
        Optional keyEncodingFormat = helper.discoverOptionalEncodingFormat(SerializationFormatFactory.class, PulsarTableOptions.KEY_FORMAT);
        keyEncodingFormat.ifPresent(format -> {
            if (!format.getChangelogMode().containsOnly(RowKind.INSERT)) {
                throw new ValidationException(String.format("A key format should only deal with INSERT-only records. But %s has a changelog mode of %s.", helper.getOptions().get(PulsarTableOptions.KEY_FORMAT), format.getChangelogMode()));
            }
        });
        return keyEncodingFormat;
    }

    private static DecodingFormat<DeserializationSchema<RowData>> getValueDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        return helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, FactoryUtil.FORMAT).orElseGet(() -> helper.discoverDecodingFormat(DeserializationFormatFactory.class, PulsarTableOptions.VALUE_FORMAT));
    }

    private static EncodingFormat<SerializationSchema<RowData>> getValueEncodingFormat(FactoryUtil.TableFactoryHelper helper) {
        return helper.discoverOptionalEncodingFormat(SerializationFormatFactory.class, FactoryUtil.FORMAT).orElseGet(() -> helper.discoverEncodingFormat(SerializationFormatFactory.class, PulsarTableOptions.VALUE_FORMAT));
    }

    private static void validatePKConstraints(ObjectIdentifier tableName, CatalogTable catalogTable, Format format) {
        if (catalogTable.getSchema().getPrimaryKey().isPresent() && format.getChangelogMode().containsOnly(RowKind.INSERT)) {
            Configuration options = Configuration.fromMap((Map)catalogTable.getOptions());
            String formatName = (String)options.getOptional(FactoryUtil.FORMAT).orElse(options.get(PulsarTableOptions.VALUE_FORMAT));
            throw new ValidationException(String.format("The Pulsar table '%s' with '%s' format doesn't support defining PRIMARY KEY constraint on the table, because it can't guarantee the semantic of primary key.", tableName.asSummaryString(), formatName));
        }
    }

    protected PulsarDynamicTableSource createPulsarTableSource(DataType physicalDataType, @Nullable DecodingFormat<DeserializationSchema<RowData>> keyDecodingFormat, DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat, int[] keyProjection, int[] valueProjection, @Nullable String keyPrefix, @Nullable List<String> topics, @Nullable String topicPattern, String serviceUrl, String adminUrl, Properties properties, PulsarTableOptions.StartupOptions startupOptions) {
        return new PulsarDynamicTableSource(physicalDataType, keyDecodingFormat, valueDecodingFormat, keyProjection, valueProjection, keyPrefix, topics, topicPattern, serviceUrl, adminUrl, properties, startupOptions, false);
    }
}

